/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.event;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.PeriodicTaskExecutor;

public class PeriodicTaskDemo
extends Scene {
    private PeriodicTaskExecutor task;

    public PeriodicTaskDemo() {
        this.setBackgroundColor("white");
        this.add(new Actor[]{new CounterText()});
    }

    public static void main(String[] args) {
        Game.start((Scene)new PeriodicTaskDemo(), (int)400, (int)200);
    }

    private class CounterText
    extends Text {
        public CounterText() {
            super("0", 2.0);
            this.setCenter(0.0, 0.0);
            this.start();
            this.addKeyStrokeListener(e -> {
                if (e.getKeyCode() == 32) {
                    if (PeriodicTaskDemo.this.task == null) {
                        this.start();
                    } else {
                        this.stop();
                    }
                } else if (e.getKeyCode() == 80) {
                    if (PeriodicTaskDemo.this.task.isPaused) {
                        PeriodicTaskDemo.this.task.resume();
                    } else {
                        PeriodicTaskDemo.this.task.pause();
                    }
                }
            });
        }

        public void start() {
            PeriodicTaskDemo.this.task = new PeriodicTaskExecutor(0.1, counter -> this.setContent(counter));
            this.addFrameUpdateListener((FrameUpdateListener)PeriodicTaskDemo.this.task);
        }

        public void stop() {
            PeriodicTaskDemo.this.task.unregister();
            PeriodicTaskDemo.this.task = null;
        }
    }
}

