/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.physics;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Random;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.BodyType;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import java.awt.Color;
import java.awt.event.KeyEvent;

public class MarbleDemo
extends Scene
implements KeyStrokeListener {
    private final Rectangle ground;

    public MarbleDemo() {
        new Funnel();
        this.repeat(0.2, counter -> {
            Circle marble = this.makeMarble();
            this.add(new Actor[]{marble});
            marble.makeDynamic();
            marble.setPosition(0.0, 500.0);
            marble.applyImpulse(new Vector(Random.range() * 200.0 - 100.0, Random.range() * -300.0 - 100.0));
        });
        this.ground = new Rectangle(110.0, 10.0);
        this.ground.setPosition(-50.0, -10.0);
        this.ground.makeStatic();
        this.add(new Actor[]{this.ground});
        this.getCamera().setMeter(0.5);
    }

    public void onKeyDown(KeyEvent e) {
        if (this.ground.getBodyType() == BodyType.STATIC) {
            this.ground.makeSensor();
            this.ground.setColor(new Color(255, 255, 255, 100));
        } else {
            this.ground.makeStatic();
            this.ground.setColor(Color.WHITE);
        }
    }

    public void onKeyUp(KeyEvent e) {
    }

    public Circle makeMarble() {
        class Marble
        extends Circle
        implements FrameUpdateListener {
            public Marble(float diameter) {
                super((double)diameter);
            }

            public void onFrameUpdate(double pastTime) {
                if (this.getCenter().getLength() > 1000.0) {
                    MarbleDemo.this.remove(new Actor[]{this});
                }
            }
        }
        Marble marble = new Marble(Random.range((int)20) + 10);
        marble.makeDynamic();
        marble.setGravityScale(2.0);
        marble.setColor(new Color(Random.range((int)255), Random.range((int)255), Random.range((int)255)));
        return marble;
    }

    public static void main(String[] args) {
        Game.start((Scene)new MarbleDemo(), (int)1000, (int)800);
    }

    class Funnel {
        private static final int THICKNESS = 10;
        private static final int LENGTH_SLANTED = 200;
        private static final int LENGTH_VERTICAL = 120;
        private static final int NARROW_RADIUS = 50;

        public Funnel() {
            Rectangle[] allRectangles;
            Rectangle slantedLeft = new Rectangle(10.0, 200.0);
            slantedLeft.setPosition(-47.5, 112.5);
            Rectangle slatedRight = new Rectangle(10.0, 200.0);
            slatedRight.setPosition(50.0, 120.0);
            Rectangle verticalLeft = new Rectangle(10.0, 120.0);
            verticalLeft.setPosition(-50.0, 0.0);
            Rectangle verticalRight = new Rectangle(10.0, 120.0);
            verticalRight.setPosition(50.0, 0.0);
            for (Rectangle r : allRectangles = new Rectangle[]{slantedLeft, slatedRight, verticalLeft, verticalRight}) {
                r.setColor(Color.WHITE);
                MarbleDemo.this.add(new Actor[]{r});
                r.makeStatic();
            }
            MarbleDemo.this.setGravity(new Vector(0.0, -30.0));
            slantedLeft.setRotation(45.0);
            slatedRight.setRotation(-45.0);
        }
    }
}

