/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.physics;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.animation.AnimationMode;
import de.pirckheimer_gymnasium.engine_pi.animation.Interpolator;
import de.pirckheimer_gymnasium.engine_pi.animation.ValueAnimator;
import de.pirckheimer_gymnasium.engine_pi.animation.interpolation.ReverseEaseDouble;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi.event.PeriodicTaskExecutor;
import java.awt.Color;
import java.awt.event.KeyEvent;

public class ParticlesDemo
extends Scene
implements KeyStrokeListener {
    private static final int WIDTH = 1240;
    private static final int HEIGHT = 812;

    public ParticlesDemo() {
        Rectangle left = new Rectangle(200.0, 10.0);
        left.setPosition(-356.66666666666663, -50.0);
        left.rotateBy(-21.0);
        left.makeStatic();
        left.setColor(Color.white);
        left.setElasticity(15.0);
        this.add(new Actor[]{left});
        Rectangle right = new Rectangle(200.0, 10.0);
        right.setPosition(206.66666666666666, 0.0);
        right.rotateBy(45.0);
        right.makeStatic();
        right.setColor(Color.white);
        right.setElasticity(15.0);
        this.add(new Actor[]{right});
        this.addKeyStrokeListener(this);
        this.repeat(1.0, counter -> this.createCircle(this.getMousePosition(), Color.YELLOW));
        Rectangle r1 = new Rectangle(1240.0, 10.0);
        r1.setPosition(-620.0, -406.0);
        Rectangle r2 = new Rectangle(10.0, 812.0);
        r2.setPosition(-620.0, -406.0);
        Rectangle r3 = new Rectangle(1240.0, 10.0);
        r3.setPosition(-620.0, 396.0);
        Rectangle r4 = new Rectangle(10.0, 812.0);
        r4.setPosition(610.0, -406.0);
        this.add(new Actor[]{r1, r2, r3, r4});
        r1.makeStatic();
        r2.makeStatic();
        r3.makeStatic();
        r4.makeStatic();
        r1.setColor(Color.DARK_GRAY);
        r2.setColor(Color.DARK_GRAY);
        r3.setColor(Color.DARK_GRAY);
        r4.setColor(Color.DARK_GRAY);
        r1.addCollisionListener(event -> this.remove(new Actor[]{event.getColliding()}));
        this.setGravity(new Vector(0.0, -600.0));
        this.getCamera().setMeter(1.0);
        left.animateColor(5.0, Color.YELLOW);
        this.addFrameUpdateListener((FrameUpdateListener)new ValueAnimator(5.0, arg_0 -> ((Rectangle)left).setX(arg_0), (Interpolator)new ReverseEaseDouble(left.getX(), left.getX() + 200.0), AnimationMode.REPEATED, (FrameUpdateListenerRegistration)this));
    }

    private void createCircle(Vector position, Color color) {
        Circle circle = new Circle(6.0);
        PeriodicTaskExecutor emitter = this.repeat(0.01, counter -> {
            Circle particle = new Circle(3.0);
            particle.setPosition(circle.getCenter().subtract(new Vector(1.0, 1.0)));
            particle.setColor(Color.RED);
            particle.setLayerPosition(-1);
            particle.animateParticle(0.5);
            particle.animateColor(0.25, Color.YELLOW);
            particle.applyImpulse(new Vector(6000.0 * ((double)((float)Math.random()) - 0.5), 6000.0 * ((double)((float)Math.random()) - 0.5)));
            this.add(new Actor[]{particle});
        });
        circle.setPosition(position);
        circle.makeDynamic();
        circle.setColor(color);
        circle.addFrameUpdateListener((FrameUpdateListener)emitter);
        this.add(new Actor[]{circle});
    }

    public void onKeyDown(KeyEvent e) {
        if (e.getKeyCode() == 153) {
            this.getCamera().rotateBy(0.1);
        }
    }

    public static void main(String[] args) {
        Game.debug();
        Game.start((Scene)new ParticlesDemo(), (int)1240, (int)812);
    }
}

