/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.stateful_animation;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureBuilder;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureData;
import de.pirckheimer_gymnasium.engine_pi_demos.stateful_animation.StatefulPlayerCharacter;
import java.awt.Color;
import java.util.ArrayList;

public class StatefulAnimationDemo
extends Scene {
    public StatefulAnimationDemo() {
        StatefulPlayerCharacter character = new StatefulPlayerCharacter();
        this.setupGround();
        this.add(new Actor[]{character});
        this.setFocus((Actor)character);
        this.setGravityOfEarth();
    }

    private void setupGround() {
        Rectangle ground = this.makePlatform(200.0, 0.2);
        ground.setCenter(0.0, -5.0);
        ground.setColor(new Color(255, 195, 150));
        this.makePlatform(12.0, 0.3).setCenter(16.0, -1.0);
        this.makePlatform(7.0, 0.3).setCenter(25.0, 2.0);
        this.makePlatform(20.0, 0.3).setCenter(35.0, 6.0);
        this.makeBall(5.0).setCenter(15.0, 3.0);
    }

    private Rectangle makePlatform(double w, double h) {
        Rectangle r = new Rectangle(w, h);
        r.setColor(new Color(0, 194, 255));
        r.makeStatic();
        ArrayList<FixtureData> platformFixtures = new ArrayList<FixtureData>();
        FixtureData top = new FixtureData(FixtureBuilder.axisParallelRectangular((double)0.1, (double)(h - 0.1), (double)(w - 0.2), (double)0.1));
        top.setFriction(0.2);
        top.setRestitution(0.0);
        FixtureData left = new FixtureData(FixtureBuilder.axisParallelRectangular((double)0.0, (double)0.0, (double)0.1, (double)h));
        left.setFriction(0.0);
        left.setRestitution(0.0);
        FixtureData right = new FixtureData(FixtureBuilder.axisParallelRectangular((double)(w - 0.1), (double)0.0, (double)0.1, (double)h));
        right.setFriction(0.0);
        right.setRestitution(0.0);
        FixtureData bottom = new FixtureData(FixtureBuilder.axisParallelRectangular((double)0.0, (double)0.0, (double)w, (double)0.1));
        bottom.setFriction(0.0);
        bottom.setRestitution(0.0);
        platformFixtures.add(top);
        platformFixtures.add(left);
        platformFixtures.add(right);
        platformFixtures.add(bottom);
        r.setFixtures(() -> platformFixtures);
        this.add(new Actor[]{r});
        return r;
    }

    private Circle makeBall(double d) {
        Circle circle = new Circle(d);
        circle.makeDynamic();
        this.add(new Actor[]{circle});
        return circle;
    }

    public static void main(String[] args) {
        Game.start((Scene)new StatefulAnimationDemo(), (int)1200, (int)820);
    }
}

