/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionEvent;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionListener;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import java.awt.Color;
import java.awt.event.KeyEvent;

public class BallThrowDemo
extends Scene
implements CollisionListener<Actor>,
KeyStrokeListener {
    private static final int WIDTH = 1240;
    private static final int HEIGHT = 812;
    private final Circle ball = new Circle(20.0);
    private long startTime;
    private static final double DURCHMESSER = 0.2;
    private static final double HOEHE_UEBER_BODEN = 1.0;
    private static final double MASSE = 1.0;
    private static final double IMPULS = 10.0;
    private static final double WINKEL = 60.0;
    private static final int PIXEL_PER_METER = 100;
    private static final float GROUND_DEPTH = 700.0f;
    private static final float DISTANCE_LEFT = 50.0f;

    public BallThrowDemo() {
        this.add(new Actor[]{this.ball});
        this.ball.setColor(Color.RED);
        this.ball.makeDynamic();
        this.ball.setDensity(1.0);
        this.ball.setCenter(50.0, 810.0);
        Rectangle ground = new Rectangle(100.0, 20.0);
        ground.setPosition(0.0, 700.0);
        this.add(new Actor[]{ground});
        ground.setColor(Color.WHITE);
        ground.makeStatic();
        this.ball.addCollisionListener((Actor)ground, (CollisionListener)this);
        this.getCamera().setMeter(3.0);
        this.setFocus((Actor)ground);
    }

    public void onKeyDown(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 83: {
                this.start();
                break;
            }
            case 82: {
                this.reset();
            }
        }
    }

    private void start() {
        this.startTime = System.currentTimeMillis();
        this.setGravity(new Vector(0.0, -9.81));
        Vector impuls = new Vector(Math.cos(Math.toRadians(60.0)) * 10.0, Math.sin(Math.toRadians(60.0)) * 10.0);
        this.ball.applyImpulse(impuls);
    }

    private void reset() {
        this.setGravity(new Vector(0.0, 0.0));
        this.ball.setCenter(50.0, 590.0);
        this.ball.resetMovement();
    }

    public void onCollision(CollisionEvent<Actor> e) {
        long endzeit = System.currentTimeMillis();
        long zeitdifferenz = endzeit - this.startTime;
        double distanz = (this.ball.getCenter().getX() - 50.0) / 100.0;
        System.out.println("Der Ball ist auf dem Boden aufgeschlagen. Seit Simulationsstart sind " + zeitdifferenz / 1000L + " Sekunden und " + zeitdifferenz % 1000L + " Millisekunden vergangen.\nDer Ball diese Distanz zur\u00fcckgelegt: " + distanz + " m");
    }

    public static void main(String[] args) {
        Game.start((Scene)new BallThrowDemo(), (int)1240, (int)812);
    }
}

