/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos;

import de.pirckheimer_gymnasium.engine_pi.Camera;
import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseButton;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListener;
import java.awt.event.KeyEvent;

public class CameraDemo
extends Scene
implements MouseClickListener,
KeyStrokeListener {
    Camera camera = this.getCamera();
    Text focus;

    public CameraDemo() {
        this.addText("Camera demo", 5.0).setColor("white");
        this.focus = this.addText("Focus");
        this.focus.setColor("yellow").setPosition(0.0, 4.0);
        this.camera.setFocus((Actor)this.focus);
    }

    public void onMouseDown(Vector position, MouseButton button) {
        this.camera.removeFocus();
        this.camera.moveTo(position);
        System.out.println(this.camera);
    }

    private void moveFocus(int dX, int dY) {
        this.camera.setFocus((Actor)this.focus);
        this.focus.moveBy((double)dX, (double)dY);
    }

    public void onKeyDown(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 49: {
                this.camera.moveTo(new Vector(1.0, 1.0));
                break;
            }
            case 38: {
                this.moveFocus(0, 1);
                break;
            }
            case 37: {
                this.moveFocus(-1, 0);
                break;
            }
            case 40: {
                this.moveFocus(0, -1);
                break;
            }
            case 39: {
                this.moveFocus(1, 0);
                break;
            }
            case 82: {
                this.camera.rotateBy(-30.0);
                break;
            }
            case 76: {
                this.camera.rotateBy(30.0);
                break;
            }
            case 50: {
                this.camera.rotateTo(0.0);
                break;
            }
            case 51: {
                this.camera.rotateTo(90.0);
                break;
            }
            case 52: {
                this.camera.rotateTo(180.0);
                break;
            }
            case 53: {
                this.camera.rotateTo(270.0);
            }
        }
        System.out.println(this.camera);
    }

    public static void main(String[] args) {
        Game.start((Scene)new CameraDemo());
    }
}

