/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.BodyType;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Geometry;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionEvent;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseButton;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListener;
import java.awt.Color;

public class ForceKlickEnvironment
extends Scene
implements CollisionListener<Actor>,
MouseClickListener,
FrameUpdateListener {
    public static final float FIELD_WIDTH = 85.0f;
    public static final float FIELD_DEPTH = 50.0f;
    private final Actor attack;
    private final Geometry[] walls = new Geometry[4];
    private Actor attackedLast = null;
    private final Rectangle stange;
    private KlickMode klickMode = KlickMode.ATTACK_POINT;
    private Vector lastAttack;

    public void onCollision(CollisionEvent<Actor> event) {
        this.attackedLast = event.getColliding();
    }

    public void onCollisionEnd(CollisionEvent<Actor> colliding) {
        if (this.attackedLast == colliding.getColliding()) {
            this.attackedLast = null;
        }
    }

    public ForceKlickEnvironment() {
        Rectangle boden = new Rectangle(85.0, 1.0);
        boden.setPosition(0.0, 50.0);
        boden.setColor(Color.WHITE);
        boden.makeStatic();
        Rectangle links = new Rectangle(1.0, 50.0);
        Rectangle rechts = new Rectangle(1.0, 50.0);
        rechts.setPosition(84.0, 0.0);
        Rectangle oben = new Rectangle(85.0, 1.0);
        this.walls[1] = links;
        this.walls[2] = rechts;
        this.walls[3] = oben;
        for (int i = 1; i <= 3; ++i) {
            this.walls[i].setColor(Color.WHITE);
            this.walls[i].setVisible(false);
            this.walls[i].makeSensor();
        }
        Rectangle stab = new Rectangle(1.0, 0.5);
        stab.setColor(new Color(200, 50, 50));
        this.stange = stab;
        this.stange.setLayerPosition(-10);
        Circle atv = new Circle(0.5);
        atv.setColor(Color.RED);
        this.attack = atv;
        this.attack.setLayerPosition(-10);
        this.attack.addCollisionListener((CollisionListener)this);
        this.getKeyStrokeListeners().add(e -> {
            if (e.getKeyCode() == 69) {
                boolean wasActive = this.walls[1].isVisible();
                BodyType newType = wasActive ? BodyType.SENSOR : BodyType.STATIC;
                for (int i = 0; i <= 3; ++i) {
                    this.walls[i].setVisible(!wasActive);
                    this.walls[i].setBodyType(newType);
                }
            }
        });
        this.add(new Actor[]{boden});
        this.add(new Actor[]{links, rechts, oben});
        this.add(new Actor[]{stab});
        this.add(new Actor[]{atv});
        this.getCamera().setMeter(1.0);
    }

    public void onMouseDown(Vector p, MouseButton mouseButton) {
        switch (this.klickMode) {
            case ATTACK_POINT: {
                this.lastAttack = p;
                this.attack.setCenter(p);
                this.attack.setVisible(true);
                this.stange.setVisible(true);
                this.stange.setPosition(p);
                this.klickMode = KlickMode.DIRECTION_INTENSITY;
                break;
            }
            case DIRECTION_INTENSITY: {
                if (this.lastAttack == null) {
                    this.klickMode = KlickMode.ATTACK_POINT;
                    return;
                }
                this.attack.setVisible(false);
                this.stange.setVisible(false);
                Vector distance = this.lastAttack.negate().add(p);
                if (this.attackedLast != null && this.attackedLast.getBodyType() == BodyType.DYNAMIC) {
                    this.attackedLast.applyImpulse(distance.multiply(1.0), this.lastAttack);
                    this.attackedLast = null;
                }
                this.klickMode = KlickMode.ATTACK_POINT;
            }
        }
    }

    public void onMouseUp(Vector point, MouseButton mouseButton) {
    }

    public void onFrameUpdate(double pastTime) {
        if (this.klickMode == KlickMode.DIRECTION_INTENSITY) {
            Vector currentMousePos = this.getMousePosition();
            if (this.lastAttack == null) {
                return;
            }
            double vectorLength = new Vector(this.lastAttack, currentMousePos).getLength();
            if (vectorLength <= 0.0) {
                return;
            }
            this.stange.setSize(vectorLength, this.stange.getHeight());
            double rot = Vector.RIGHT.getAngle(this.lastAttack.negate().add(currentMousePos));
            if (Double.isNaN(rot)) {
                return;
            }
            if (currentMousePos.getY() < this.lastAttack.getY()) {
                rot = 360.0 - rot;
            }
            this.stange.setRotation(rot);
        }
    }

    public static void main(String[] args) {
        Game.start((Scene)new ForceKlickEnvironment(), (int)1000, (int)800);
    }

    private static enum KlickMode {
        ATTACK_POINT,
        DIRECTION_INTENSITY;

    }
}

