/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.BodyType;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Polygon;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi_demos.ForceKlickEnvironment;
import java.awt.Color;
import java.awt.event.KeyEvent;

public class JointDemo
extends ForceKlickEnvironment
implements KeyStrokeListener {
    private boolean isGravityActive = false;
    private Rectangle[] chain;
    private Circle ball;

    public JointDemo() {
        this.initialize2();
    }

    public void initialize2() {
        this.buildChain(15);
        this.buildLeash();
        this.buildHoverHolder();
        this.ball = new Circle(1.0);
        this.add(new Actor[]{this.ball});
        this.ball.setColor(Color.BLUE);
        this.ball.setPosition(new Vector(300.0, 200.0));
        this.ball.makeDynamic();
    }

    private void buildHoverHolder() {
        int FACT = 2;
        Polygon halter = new Polygon(new Vector[]{new Vector(0.0, 100.0), new Vector(50.0, 150.0), new Vector(100.0, 150.0), new Vector(150.0, 100.0), new Vector(150.0, 200.0), new Vector(0.0, 200.0)});
        this.add(new Actor[]{halter});
        halter.setColor("blue green");
        halter.makeDynamic();
        Rectangle item = new Rectangle(70.0, 40.0);
        this.add(new Actor[]{item});
        item.setPosition(60.0, 0.0);
        item.setColor("red");
        item.makeDynamic();
        halter.createDistanceJoint((Actor)item, halter.getCenter(), item.getCenter());
    }

    private void buildLeash() {
        Circle kx = new Circle(30.0);
        kx.setColor("blue");
        kx.makeDynamic();
        Circle ky = new Circle(50.0);
        ky.setPosition(50.0, 0.0);
        ky.setColor("green");
        ky.makeDynamic();
        kx.createRopeJoint((Actor)ky, new Vector(15.0, 15.0), new Vector(25.0, 25.0), 4.0);
    }

    private void buildChain(int length) {
        this.chain = new Rectangle[length];
        for (int i = 0; i < this.chain.length; ++i) {
            this.chain[i] = new Rectangle(50.0, 10.0);
            Vector posrel = new Vector((double)(45 * i), 30.0);
            this.chain[i].moveBy(posrel);
            this.chain[i].setColor("green");
            this.chain[i].setBodyType(i == 0 ? BodyType.STATIC : BodyType.DYNAMIC);
            if (i == 0) continue;
            this.chain[i - 1].createRevoluteJoint((Actor)this.chain[i], new Vector(0.0, 5.0).add(posrel));
        }
        this.add((Actor[])this.chain);
        Circle weight = new Circle(100.0);
        weight.setColor(Color.WHITE);
        weight.makeDynamic();
        Vector vektor = new Vector((double)(45 * this.chain.length), 35.0);
        weight.setCenter(new Vector(vektor.getX(), vektor.getY()));
        weight.createRevoluteJoint((Actor)this.chain[this.chain.length - 1], vektor);
        this.add(new Actor[]{weight});
    }

    public void onKeyDown(KeyEvent e) {
        if (e.getKeyCode() == 83) {
            this.isGravityActive = !this.isGravityActive;
            this.setGravity(this.isGravityActive ? new Vector(0.0, -10.0) : Vector.NULL);
        }
    }

    public static void main(String[] args) {
        Game.start((Scene)new JointDemo(), (int)1000, (int)800);
    }
}

