/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.actor;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyEvent;

public class TextAllSystemFonts
extends Scene
implements KeyStrokeListener {
    private int pageCount;
    private int page;

    public TextAllSystemFonts() {
        Text \u00fcberschrift = new Text("Alle System-Schriftarten", 2.0);
        \u00fcberschrift.setPosition(-12.0, 3.0);
        \u00fcberschrift.setColor("black");
        this.add(new Actor[]{\u00fcberschrift});
        this.loadFonts();
        this.setBackgroundColor("white");
    }

    private void loadFonts() {
        int startIndex;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] systemFonts = ge.getAvailableFontFamilyNames();
        this.pageCount = systemFonts.length / 10;
        for (int i = startIndex = this.page * 10; i < startIndex + 10; ++i) {
            String fontName = systemFonts[i];
            Text text = new Text(fontName, 1.0, fontName);
            text.setPosition(-12.0, (double)(-1 * i));
            text.setColor("black");
            this.add(new Actor[]{text});
        }
    }

    public void onKeyDown(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38) {
            this.page = this.page == 0 ? this.pageCount - 1 : --this.page;
        } else if (keyEvent.getKeyCode() == 40) {
            this.page = this.page == this.pageCount - 1 ? 0 : ++this.page;
        }
    }

    public static void main(String[] args) {
        Game.start((Scene)new TextAllSystemFonts(), (int)1020, (int)520);
        Game.setTitle((String)"Alle Schriftarten");
    }
}

