/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude;

import de.pirckheimer_gymnasium.engine_pi.actor.Tile;
import de.pirckheimer_gymnasium.engine_pi.actor.TileMap;
import de.pirckheimer_gymnasium.engine_pi.actor.TileRegistration;

public class Platform
extends TileRegistration {
    private static final int SIZE = 2;
    private static final double FRICTION = 0.5;

    public Platform(int tileCount) {
        super(tileCount, 1, 2.0);
        if (tileCount < 2) {
            throw new IllegalArgumentException("Number of tiles must be at least 2");
        }
        this.setFixtures("R 0, 1.5," + 2 * tileCount + ", 0.5");
        String basePath = "dude/tiles/";
        this.setLeftTile(TileMap.createFromImage((String)(basePath + "platform_l.png")));
        this.setMiddleTiles(TileMap.createFromImage((String)(basePath + "platform_m.png")));
        this.setRightTile(TileMap.createFromImage((String)(basePath + "platform_r.png")));
        this.makeStatic();
        this.setFriction(0.5);
        this.setElasticity(0.0);
    }

    private void setLeftTile(Tile tile) {
        this.setTile(0, 0, tile);
    }

    private void setMiddleTiles(Tile tile) {
        for (int x = 1; x < this.getTileCountX() - 1; ++x) {
            this.setTile(x, 0, tile);
        }
    }

    private void setRightTile(Tile tile) {
        this.setTile(this.getTileCountX() - 1, 0, tile);
    }
}

