/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi;

import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;

@Internal
public final class Bounds {
    private final double x;
    private final double y;
    private final double width;
    private final double height;

    public Bounds(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Bounds withCenterAtBoundsCenter(Bounds bounds) {
        return this.withCenterPoint(bounds.getCenter());
    }

    public Bounds withCenterPoint(Vector point) {
        return this.moveBy(point.subtract(this.getCenter()));
    }

    public Vector getCenter() {
        return new Vector(this.x + this.width / 2.0, this.y + this.height / 2.0);
    }

    public Bounds moveBy(Vector v) {
        return new Bounds(this.x + v.getX(), this.y + v.getY(), this.width, this.height);
    }

    public Bounds smallestCommon(Bounds bounds) {
        double x = bounds.x < this.x ? bounds.x : this.x;
        double y = bounds.y < this.y ? bounds.y : this.y;
        double dX = bounds.x + bounds.width > this.x + this.width ? bounds.x + bounds.width - x : this.x + this.width - x;
        double dY = bounds.y + bounds.height > this.y + this.height ? bounds.y + bounds.height - y : this.y + this.height - y;
        return new Bounds(x, y, dX, dY);
    }

    public Bounds above(double lowerBound) {
        if (this.y + this.height < lowerBound) {
            return this;
        }
        return new Bounds(this.x, lowerBound - this.height, this.width, this.height);
    }

    public Bounds below(double upperBound) {
        if (this.y > upperBound) {
            return this;
        }
        return new Bounds(this.x, upperBound, this.width, this.height);
    }

    public Bounds rightOf(double border) {
        if (this.x > border) {
            return this;
        }
        return new Bounds(border, this.y, this.width, this.height);
    }

    public Bounds leftOf(double border) {
        if (this.x + this.width < border) {
            return this;
        }
        return new Bounds(border - this.width, this.y, this.width, this.height);
    }

    public Bounds atPosition(double realX, double realY) {
        return new Bounds(realX, realY, this.width, this.height);
    }

    public boolean contains(Vector v) {
        return v.getX() >= this.x && v.getY() >= this.y && v.getX() <= this.x + this.width && v.getY() <= this.y + this.height;
    }

    public Vector[] points() {
        return new Vector[]{new Vector(this.x, this.y), new Vector(this.x + this.width, this.y), new Vector(this.x, this.y + this.height), new Vector(this.x + this.width, this.y + this.height)};
    }

    public boolean contains(Bounds inner) {
        return this.x <= inner.x && this.y <= inner.y && this.x + this.width >= inner.x + inner.width && this.y + this.height >= inner.y + inner.height;
    }

    public boolean above(Bounds r) {
        return this.y < r.y;
    }

    public Bounds in(Bounds outer) {
        double realX = this.x;
        double realY = this.y;
        if (this.x < outer.x) {
            realX = outer.x;
        }
        if (this.x + this.width > outer.x + outer.width) {
            realX = outer.x + outer.width - this.width;
        }
        if (this.y < outer.y) {
            realY = outer.y;
        }
        if (this.y + this.height > outer.y + outer.height) {
            realY = outer.y + outer.height - this.height;
        }
        return new Bounds(realX, realY, this.width, this.height);
    }

    public Bounds clone() {
        return new Bounds(this.x, this.y, this.width, this.height);
    }

    public String toString() {
        return "Bounding-Rectangle: getX:" + this.x + " getY: " + this.y + " getWidth: " + this.width + " getHeight: " + this.height;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Vector getPosition() {
        return new Vector(this.x, this.y);
    }
}

