/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi;

import de.pirckheimer_gymnasium.engine_pi.GameLoop;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.event.EventListeners;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseButton;
import de.pirckheimer_gymnasium.engine_pi.event.MouseWheelEvent;
import de.pirckheimer_gymnasium.engine_pi.graphics.RenderPanel;
import de.pirckheimer_gymnasium.engine_pi.resources.Container;
import de.pirckheimer_gymnasium.engine_pi.resources.ImagesContainer;
import de.pirckheimer_gymnasium.engine_pi.resources.SoundsContainer;
import de.pirckheimer_gymnasium.engine_pi.sound.Jukebox;
import de.pirckheimer_gymnasium.engine_pi.util.ImageUtil;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JOptionPane;

public final class Game {
    private static final Jukebox jukebox;
    private static boolean debug;
    private static boolean verbose;
    private static int width;
    private static int height;
    private static final Frame frame;
    private static RenderPanel renderPanel;
    private static boolean exitOnEsc;
    private static Scene scene;
    private static GameLoop gameLogic;
    private static Thread mainThread;
    private static final Collection<Integer> pressedKeys;
    private static Point mousePosition;
    private static final EventListeners<de.pirckheimer_gymnasium.engine_pi.event.KeyListener> keyListeners;

    @API
    public static void setTitle(String title) {
        frame.setTitle(title);
    }

    @API
    public static void setExitOnEsc(boolean value) {
        exitOnEsc = value;
    }

    @API
    public static Vector getFrameSizeInPixels() {
        return new Vector(width, height);
    }

    @API
    public static void start(int width, int height, Scene scene) {
        if (renderPanel != null) {
            throw new IllegalStateException("Game.start wurde bereits ausgef\u00fchrt und kann nur einmal ausgef\u00fchrt werden");
        }
        Game.width = width;
        Game.height = height;
        Game.scene = scene;
        renderPanel = new RenderPanel(width, height);
        frame.setResizable(false);
        frame.add(renderPanel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        renderPanel.allocateBuffers();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Game.exit();
            }
        });
        KeyListener keyListener = new KeyListener();
        frame.addKeyListener(keyListener);
        renderPanel.addKeyListener(keyListener);
        renderPanel.setFocusable(true);
        MouseListener mouseListener = new MouseListener();
        renderPanel.addMouseMotionListener(mouseListener);
        renderPanel.addMouseListener(mouseListener);
        renderPanel.addMouseWheelListener(Game::enqueueMouseWheelEvent);
        try {
            frame.setIconImage((Image)Game.getImages().get("assets/favicon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        mousePosition = new Point(width / 2, height / 2);
        mainThread = new Thread(Game::run, "de.pirckheimer_gymnasium.engine_pi.main");
        mainThread.start();
        mainThread.setPriority(10);
    }

    public static void start(Scene scene) {
        Game.start(800, 600, scene);
    }

    public static ImagesContainer getImages() {
        return Container.getImages();
    }

    public static SoundsContainer getSounds() {
        return Container.getSounds();
    }

    private static void run() {
        gameLogic = new GameLoop(renderPanel, Game::getActiveScene, Game::isDebug);
        gameLogic.run();
        frame.setVisible(false);
        frame.dispose();
        System.exit(0);
    }

    @Internal
    public static Vector convertMousePosition(Scene scene, Point mousePosition) {
        double zoom = scene.getCamera().getMeter();
        double rotation = scene.getCamera().getRotation();
        Vector position = scene.getCamera().getPosition();
        return new Vector(position.getX() + (Math.cos(Math.toRadians(rotation)) * (double)((float)mousePosition.x - (float)width / 2.0f) + Math.sin(Math.toRadians(rotation)) * (double)((float)mousePosition.y - (float)height / 2.0f)) / zoom, position.getY() + (Math.sin(Math.toRadians(rotation)) * (double)((float)mousePosition.x - (float)width / 2.0f) - Math.cos(Math.toRadians(rotation)) * (double)((float)mousePosition.y - (float)height / 2.0f)) / zoom);
    }

    private static void enqueueMouseWheelEvent(java.awt.event.MouseWheelEvent mouseWheelEvent) {
        MouseWheelEvent mouseWheelAction = new MouseWheelEvent(mouseWheelEvent.getPreciseWheelRotation());
        gameLogic.enqueue(() -> scene.invokeMouseWheelMoveListeners(mouseWheelAction));
    }

    public static FrameUpdateListener addFrameUpdateListener(FrameUpdateListener listener) {
        if (gameLogic == null) {
            throw new RuntimeException("Das Spiel l\u00e4uft noch nicht");
        }
        gameLogic.getFrameUpdateListener().add(listener);
        return listener;
    }

    public static void removeFrameUpdateListener(FrameUpdateListener listener) {
        gameLogic.getFrameUpdateListener().remove(listener);
    }

    public static void addKeyListener(de.pirckheimer_gymnasium.engine_pi.event.KeyListener keyListener) {
        keyListeners.add(keyListener);
    }

    public static void removeKeyListener(de.pirckheimer_gymnasium.engine_pi.event.KeyListener keyListener) {
        keyListeners.remove(keyListener);
    }

    @API
    public static void transitionToScene(Scene scene) {
        if (scene == null) {
            gameLogic.enqueue(() -> {
                scene = new Scene();
            });
        } else {
            gameLogic.enqueue(() -> {
                Game.scene = scene;
            });
        }
    }

    @API
    public static Scene getActiveScene() {
        return scene;
    }

    @API
    public static boolean isKeyPressed(int keyCode) {
        return pressedKeys.contains(keyCode);
    }

    @API
    public static boolean isRunning() {
        return frame.isVisible();
    }

    @API
    public static void setFrameSize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new RuntimeException("Die Fenstergr\u00f6\u00dfe kann nicht kleiner/gleich 0 sein. Eingabe war: " + width + " - " + height + ".");
        }
        if (renderPanel == null) {
            throw new RuntimeException("Fenster-Resizing ist erst m\u00f6glich, nachdem Game.start ausgef\u00fchrt wurde.");
        }
        int diffX = (width - Game.width) / 2;
        int diffY = (height - Game.height) / 2;
        Game.width = width;
        Game.height = height;
        renderPanel.setSize(width, height);
        renderPanel.setPreferredSize(new Dimension(width, height));
        frame.pack();
        frame.setLocation(Game.frame.getLocation().x - diffX, Game.frame.getLocation().y - diffY);
    }

    @API
    public static void setFramePosition(int x, int y) {
        frame.setLocation(x, y);
    }

    @API
    public static void exit() {
        if (mainThread == null) {
            System.exit(0);
            return;
        }
        if (!mainThread.isInterrupted()) {
            mainThread.interrupt();
        }
    }

    @API
    public static void showMessage(String message, String title) {
        JOptionPane.showMessageDialog(frame, message, title, 1);
    }

    @API
    public static String requestStringInput(String message, String title) {
        return JOptionPane.showInputDialog(frame, message, title, -1);
    }

    @API
    public static boolean requestYesNo(String message, String title) {
        return JOptionPane.showConfirmDialog(frame, message, title, 0, -1) == 0;
    }

    @API
    public static boolean requestOkCancel(String message, String title) {
        return JOptionPane.showConfirmDialog(frame, message, title, 2, -1) == 0;
    }

    @Internal
    public static Point getMousePositionInFrame() {
        return mousePosition;
    }

    @API
    public static Vector getMousePositionInCurrentScene() {
        return scene.getMousePosition();
    }

    @API
    public static boolean isDebug() {
        return debug;
    }

    @API
    public static boolean isVerbose() {
        return verbose;
    }

    @API
    public static void setVerbose(boolean value) {
        verbose = value;
    }

    @API
    public static void setDebug(boolean value) {
        debug = value;
    }

    public static Jukebox getJukebox() {
        return jukebox;
    }

    @API
    public static void takeScreenshot(String filename) {
        BufferedImage screenshot = new BufferedImage(width, height, 1);
        Graphics2D g2d = (Graphics2D)screenshot.getGraphics();
        gameLogic.render(source -> source.render(g2d, width, height));
        ImageUtil.write(screenshot, filename);
    }

    static {
        System.setProperty("sun.java2d.opengl", "true");
        System.setProperty("sun.java2d.d3d", "true");
        System.setProperty("sun.java2d.noddraw", "false");
        System.setProperty("sun.java2d.pmoffscreen", "true");
        System.setProperty("sun.java2d.ddoffscreen", "true");
        System.setProperty("sun.java2d.ddscale", "true");
        jukebox = new Jukebox();
        frame = new Frame("Engine Pi");
        exitOnEsc = true;
        scene = new Scene();
        pressedKeys = ConcurrentHashMap.newKeySet();
        keyListeners = new EventListeners();
    }

    private static class KeyListener
    extends KeyAdapter {
        private KeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.enqueueKeyEvent(e, true);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.enqueueKeyEvent(e, false);
        }

        private void enqueueKeyEvent(KeyEvent e, boolean down) {
            if (e.getKeyCode() == 27 && exitOnEsc) {
                Game.exit();
            }
            boolean pressed = pressedKeys.contains(e.getKeyCode());
            if (down) {
                if (pressed) {
                    return;
                }
                pressedKeys.add(e.getKeyCode());
            } else {
                pressedKeys.remove(e.getKeyCode());
            }
            gameLogic.enqueue(() -> {
                if (down) {
                    keyListeners.invoke(keyListener -> keyListener.onKeyDown(e));
                    scene.invokeKeyDownListeners(e);
                } else {
                    keyListeners.invoke(keyListener -> keyListener.onKeyUp(e));
                    scene.invokeKeyUpListeners(e);
                }
            });
        }
    }

    private static class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.enqueueMouseEvent(e, true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.enqueueMouseEvent(e, false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            mousePosition = e.getPoint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            mousePosition = e.getPoint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            mousePosition = e.getPoint();
        }

        private void enqueueMouseEvent(MouseEvent e, boolean down) {
            MouseButton button;
            Vector sourcePosition = Game.convertMousePosition(scene, e.getPoint());
            switch (e.getButton()) {
                case 1: {
                    button = MouseButton.LEFT;
                    break;
                }
                case 3: {
                    button = MouseButton.RIGHT;
                    break;
                }
                default: {
                    return;
                }
            }
            gameLogic.enqueue(() -> {
                if (down) {
                    scene.invokeMouseDownListeners(sourcePosition, button);
                } else {
                    scene.invokeMouseUpListeners(sourcePosition, button);
                }
            });
        }
    }
}

