/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Random;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.BodyType;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Image;
import de.pirckheimer_gymnasium.engine_pi.actor.Polygon;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import java.awt.Color;
import java.net.JarURLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

@Internal
public final class MainAnimation {
    public static final int VERSION_CODE = 40000;
    public static final String VERSION_STRING = "v4.0.0-dev";
    public static final boolean IS_JAR = MainAnimation.isJar();
    public static final long BUILD_TIME = IS_JAR ? MainAnimation.getBuildTime() / 1000L : System.currentTimeMillis() / 1000L;

    @API
    public static boolean isJar() {
        String className = MainAnimation.class.getName().replace('.', '/');
        String classJar = MainAnimation.class.getResource("/" + className + ".class").toString();
        return classJar.startsWith("jar:");
    }

    @API
    public static String getJarName() {
        String className = MainAnimation.class.getName().replace('.', '/');
        String classJar = MainAnimation.class.getResource("/" + className + ".class").toString();
        if (classJar.startsWith("jar:")) {
            String[] values;
            for (String value : values = classJar.split("/")) {
                if (!value.contains("!")) continue;
                try {
                    return URLDecoder.decode(value.substring(0, value.length() - 1), StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    @API
    public static long getBuildTime() {
        try {
            String uri = MainAnimation.class.getName().replace('.', '/') + ".class";
            JarURLConnection j = (JarURLConnection)ClassLoader.getSystemResource(uri).openConnection();
            long time = j.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime();
            return time > 0L ? time : System.currentTimeMillis() / 1000L;
        }
        catch (Exception e) {
            return System.currentTimeMillis() / 1000L;
        }
    }

    public static void main(String[] args) {
        Game.start(800, 600, new Scene(){
            private final List<Actor> items = new ArrayList<Actor>();
            {
                Image image = new Image("assets/logo.png", 25.0);
                image.setBodyType(BodyType.STATIC);
                image.setCenter(0.0, -3.0);
                this.add(image);
                this.setGravity(new Vector(0.0, -9.81));
                Rectangle ground = new Rectangle(20.0, 0.2);
                ground.setCenter(0.0, -6.0);
                ground.setElasticity(0.9);
                ground.setFriction(0.2);
                ground.setBodyType(BodyType.STATIC);
                this.add(ground);
                for (int i = 0; i < 3; ++i) {
                    Rectangle a = new Rectangle(1.0, 1.0);
                    a.setPosition(-5.0, -2.0);
                    a.setElasticity(0.9);
                    a.setFriction(1.0);
                    a.setBodyType(BodyType.DYNAMIC);
                    a.setColor(new Color(26, 113, 156));
                    a.setRotation(30.0);
                    this.spawnItem(a);
                    Circle b = new Circle(1.0);
                    b.setPosition(5.0, -1.0);
                    b.setElasticity(0.9);
                    b.setFriction(1.0);
                    b.setBodyType(BodyType.DYNAMIC);
                    b.setColor(new Color(158, 5, 5));
                    b.applyImpulse(new Vector(Random.range(-100, 100), 0.0));
                    this.spawnItem(b);
                    Polygon c = new Polygon(new Vector(0.0, 0.0), new Vector(1.0, 0.0), new Vector(0.5, 1.0));
                    c.setElasticity(0.9);
                    c.setFriction(1.0);
                    c.setBodyType(BodyType.DYNAMIC);
                    c.setColor(new Color(25, 159, 69));
                    c.setRotation(-20.0);
                    this.spawnItem(c);
                }
                Date date = new Date(BUILD_TIME * 1000L);
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss z");
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                Text text = new Text("Build #40000   " + sdf.format(date), 0.5);
                text.setPosition(-10.0, -7.0);
                text.setColor(Color.WHITE);
                text.setBodyType(BodyType.STATIC);
                this.add(text);
                this.addFrameUpdateListener(time -> {
                    for (Actor item : this.items) {
                        if (!(item.getCenter().getY() < -10.0)) continue;
                        this.spawnItem(item);
                    }
                });
                this.addKeyListener(e -> {
                    if (e.getKeyCode() == 68) {
                        Game.setDebug(!Game.isDebug());
                    }
                });
            }

            private void spawnItem(Actor item) {
                if (!item.isMounted()) {
                    this.delay(Random.range(5), () -> {
                        this.items.add(item);
                        this.add(item);
                    });
                }
                item.resetMovement();
                item.setCenter(Random.range(-7, 7), Random.range(0, 5));
            }
        });
        Game.setExitOnEsc(true);
        Game.setTitle("Engine Pi v4.0.0-dev");
    }
}

