/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi;

import de.pirckheimer_gymnasium.engine_pi.Bounds;
import de.pirckheimer_gymnasium.engine_pi.Camera;
import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Layer;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.ActorCreator;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.event.EventListenerHelper;
import de.pirckheimer_gymnasium.engine_pi.event.EventListeners;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListenerContainer;
import de.pirckheimer_gymnasium.engine_pi.event.KeyListener;
import de.pirckheimer_gymnasium.engine_pi.event.KeyListenerContainer;
import de.pirckheimer_gymnasium.engine_pi.event.MouseButton;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListenerContainer;
import de.pirckheimer_gymnasium.engine_pi.event.MouseWheelEvent;
import de.pirckheimer_gymnasium.engine_pi.event.MouseWheelListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseWheelListenerContainer;
import de.pirckheimer_gymnasium.engine_pi.physics.WorldHandler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RopeJoint;

public class Scene
implements KeyListenerContainer,
MouseClickListenerContainer,
MouseWheelListenerContainer,
FrameUpdateListenerContainer,
ActorCreator {
    private static final Color REVOLUTE_JOINT_COLOR = Color.BLUE;
    private static final Color ROPE_JOINT_COLOR = Color.CYAN;
    private static final Color DISTANCE_JOINT_COLOR = Color.ORANGE;
    private static final Color PRISMATIC_JOINT_COLOR = Color.GREEN;
    private final Camera camera;
    private final EventListeners<KeyListener> keyListeners = new EventListeners();
    private final EventListeners<MouseClickListener> mouseClickListeners = new EventListeners();
    private final EventListeners<MouseWheelListener> mouseWheelListeners = new EventListeners();
    private final EventListeners<FrameUpdateListener> frameUpdateListeners = new EventListeners();
    private final List<Layer> layers = new ArrayList<Layer>();
    private Color backgroundColor = Color.BLACK;
    private final Layer mainLayer;
    private static final int JOINT_CIRCLE_RADIUS = 10;
    private static final int JOINT_RECTANGLE_SIDE = 12;

    public Scene() {
        this.camera = new Camera();
        this.mainLayer = new Layer();
        this.mainLayer.setLayerPosition(0);
        this.addLayer(this.mainLayer);
        EventListenerHelper.autoRegisterListeners(this);
    }

    @Override
    public Scene getScene() {
        return this;
    }

    @API
    public Layer getMainLayer() {
        return this.mainLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public final void step(double deltaSeconds, Function<Runnable, Future<?>> invoker) throws InterruptedException {
        List<Layer> list = this.layers;
        synchronized (list) {
            ArrayList layerFutures = new ArrayList(this.layers.size());
            for (Layer layer : this.layers) {
                Future<?> future = invoker.apply(() -> layer.step(deltaSeconds));
                layerFutures.add(future);
            }
            for (Future future : layerFutures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public final void render(Graphics2D g, int width, int height) {
        AffineTransform base = g.getTransform();
        List<Layer> list = this.layers;
        synchronized (list) {
            for (Layer layer : this.layers) {
                layer.render(g, this.camera, width, height);
                g.setTransform(base);
            }
        }
        if (Game.isDebug()) {
            this.renderJoints(g);
        }
    }

    @Internal
    final void sortLayers() {
        this.layers.sort(Comparator.comparingInt(Layer::getLayerPosition));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @API
    public final void addLayer(Layer layer) {
        List<Layer> list = this.layers;
        synchronized (list) {
            layer.setParent(this);
            this.layers.add(layer);
            this.sortLayers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @API
    public final void removeLayer(Layer layer) {
        List<Layer> list = this.layers;
        synchronized (list) {
            this.layers.remove(layer);
            layer.setParent(null);
        }
    }

    @API
    public Bounds getVisibleArea(Vector gameSizeInPixels) {
        return this.mainLayer.getVisibleArea(gameSizeInPixels);
    }

    @API
    public final Camera getCamera() {
        return this.camera;
    }

    @Internal
    private void renderJoints(Graphics2D g) {
        for (Layer layer : this.layers) {
            for (Joint j = layer.getWorldHandler().getWorld().getJointList(); j != null; j = j.getNext()) {
                Scene.renderJoint(j, g, layer);
            }
        }
    }

    @Internal
    private static void renderJoint(Joint j, Graphics2D g, Layer layer) {
        Vec2 anchorA = new Vec2();
        Vec2 anchorB = new Vec2();
        j.getAnchorA(anchorA);
        j.getAnchorB(anchorB);
        Vector aInPx = layer.translateWorldPointToFramePxCoordinates(Vector.of(anchorA));
        Vector bInPx = layer.translateWorldPointToFramePxCoordinates(Vector.of(anchorB));
        if (j instanceof RevoluteJoint) {
            g.setColor(REVOLUTE_JOINT_COLOR);
            g.drawOval((int)aInPx.getX() - 5, (int)aInPx.getY() - 5, 10, 10);
        } else if (j instanceof RopeJoint) {
            Scene.renderJointRectangle(g, ROPE_JOINT_COLOR, aInPx, bInPx, layer.calculatePixelPerMeter());
        } else if (j instanceof DistanceJoint) {
            Scene.renderJointRectangle(g, DISTANCE_JOINT_COLOR, aInPx, bInPx, layer.calculatePixelPerMeter());
        } else if (j instanceof PrismaticJoint) {
            Scene.renderJointRectangle(g, PRISMATIC_JOINT_COLOR, aInPx, bInPx, layer.calculatePixelPerMeter());
        }
    }

    @Internal
    private static void renderJointRectangle(Graphics2D g, Color color, Vector a, Vector b, double pixelPerMeter) {
        g.setColor(color);
        g.drawRect((int)a.getX() - 5, (int)a.getY() - 5, 12, 12);
        g.drawRect((int)b.getX() - 5, (int)b.getY() - 5, 12, 12);
        g.drawLine((int)a.getX(), (int)a.getY(), (int)b.getX(), (int)b.getY());
        Vector middle = a.add(b).divide(2.0);
        g.drawString(String.valueOf(a.getDistance(b).divide(pixelPerMeter).getLength()), (int)middle.getX(), (int)middle.getY());
    }

    @Internal
    public final WorldHandler getWorldHandler() {
        return this.mainLayer.getWorldHandler();
    }

    @API
    public void setGravity(Vector gravity) {
        this.mainLayer.setGravity(gravity);
    }

    @API
    public void setGravity(double gravityX, double gravityY) {
        this.setGravity(new Vector(gravityX, gravityY));
    }

    @API
    public void setGravityOfEarth() {
        this.setGravity(0.0, -9.81);
    }

    @API
    public void setPhysicsPaused(boolean worldPaused) {
        this.mainLayer.getWorldHandler().setWorldPaused(worldPaused);
    }

    @API
    public boolean isPhysicsPaused() {
        return this.mainLayer.getWorldHandler().isWorldPaused();
    }

    @API
    public final void add(Actor ... actors) {
        for (Actor actor : actors) {
            this.mainLayer.add(actor);
        }
    }

    @API
    public final void remove(Actor ... actors) {
        for (Actor actor : actors) {
            this.mainLayer.remove(actor);
        }
    }

    @Override
    @API
    public EventListeners<KeyListener> getKeyListeners() {
        return this.keyListeners;
    }

    @Override
    @API
    public EventListeners<MouseClickListener> getMouseClickListeners() {
        return this.mouseClickListeners;
    }

    @Override
    @API
    public EventListeners<MouseWheelListener> getMouseWheelListeners() {
        return this.mouseWheelListeners;
    }

    @Override
    @API
    public EventListeners<FrameUpdateListener> getFrameUpdateListeners() {
        return this.frameUpdateListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public final void invokeFrameUpdateListeners(double deltaSeconds) {
        this.frameUpdateListeners.invoke(frameUpdateListener -> frameUpdateListener.onFrameUpdate(deltaSeconds));
        List<Layer> list = this.layers;
        synchronized (list) {
            for (Layer layer : this.layers) {
                layer.invokeFrameUpdateListeners(deltaSeconds);
            }
        }
    }

    @Internal
    final void invokeKeyDownListeners(KeyEvent e) {
        this.keyListeners.invoke(keyListener -> keyListener.onKeyDown(e));
    }

    @Internal
    final void invokeKeyUpListeners(KeyEvent e) {
        this.keyListeners.invoke(keyListener -> keyListener.onKeyUp(e));
    }

    @Internal
    final void invokeMouseDownListeners(Vector position, MouseButton button) {
        this.mouseClickListeners.invoke(mouseClickListener -> mouseClickListener.onMouseDown(position, button));
    }

    @Internal
    final void invokeMouseUpListeners(Vector position, MouseButton button) {
        this.mouseClickListeners.invoke(mouseClickListener -> mouseClickListener.onMouseUp(position, button));
    }

    @Internal
    final void invokeMouseWheelMoveListeners(MouseWheelEvent mouseWheelEvent) {
        this.mouseWheelListeners.invoke(mouseWheelListener -> mouseWheelListener.onMouseWheelMove(mouseWheelEvent));
    }

    @API
    public final Vector getMousePosition() {
        return Game.convertMousePosition(this, Game.getMousePositionInFrame());
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

