/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.animation.AnimationFrame;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.event.EventListeners;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureBuilder;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourceLoader;
import de.pirckheimer_gymnasium.engine_pi.util.FileUtil;
import de.pirckheimer_gymnasium.engine_pi.util.GifDecoder;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;

@API
public class Animation
extends Actor
implements FrameUpdateListener {
    private final AnimationFrame[] frames;
    private final double width;
    private final double height;
    private transient double currentTime;
    private transient int currentIndex;
    private final EventListeners<Runnable> onCompleteListeners = new EventListeners();

    private Animation(AnimationFrame[] frames, double width, double height) {
        super(() -> {
            if (frames.length < 1) {
                throw new RuntimeException("Eine Animation kann nicht mit einem leeren Frames-Array initialisiert werden.");
            }
            return FixtureBuilder.rectangle(width, height);
        });
        for (AnimationFrame frame : frames) {
            if (!(frame.getDuration() <= 0.0)) continue;
            throw new RuntimeException("Ein Frame muss l\u00e4nger als 0 Sekunden sein.");
        }
        this.frames = (AnimationFrame[])frames.clone();
        this.width = width;
        this.height = height;
        this.currentTime = 0.0;
        this.currentIndex = 0;
    }

    public Animation(Animation animation) {
        this(animation.frames, animation.width, animation.height);
        animation.onCompleteListeners.invoke(this::addOnCompleteListener);
    }

    @Internal
    public AnimationFrame[] getFrames() {
        return (AnimationFrame[])this.frames.clone();
    }

    @API
    public double getWidth() {
        return this.width;
    }

    @API
    public double getHeight() {
        return this.height;
    }

    @API
    public void addOnCompleteListener(Runnable listener) {
        this.onCompleteListeners.add(listener);
    }

    @Override
    @Internal
    public void onFrameUpdate(double deltaSeconds) {
        this.currentTime += deltaSeconds;
        AnimationFrame currentFrame = this.frames[this.currentIndex];
        while (this.currentTime > currentFrame.getDuration()) {
            this.currentTime -= currentFrame.getDuration();
            if (this.currentIndex + 1 == this.frames.length) {
                this.onCompleteListeners.invoke(Runnable::run);
                this.currentIndex = 0;
                continue;
            }
            ++this.currentIndex;
        }
    }

    @Override
    public void render(Graphics2D g, double pixelPerMeter) {
        this.frames[this.currentIndex].render(g, this.width * pixelPerMeter, this.height * pixelPerMeter, false, false);
    }

    @API
    public static Animation createFromSpritesheet(double frameDuration, String filepath, int x, int y, double width, double height) {
        if (frameDuration <= 0.0) {
            throw new RuntimeException("Frame-L\u00e4nge muss gr\u00f6\u00dfer als 0 sein");
        }
        BufferedImage image = (BufferedImage)Game.getImages().get(filepath);
        if (image.getWidth() % x != 0) {
            throw new RuntimeException(String.format("Spritesheet hat nicht die richtigen Ma\u00dfe (Breite: %d) um es auf %d Elemente in getX-Richtung aufzuteilen.", image.getWidth(), x));
        }
        if (image.getHeight() % y != 0) {
            throw new RuntimeException(String.format("Spritesheet hat nicht die richtigen Ma\u00dfe (H\u00f6he: %d) um es auf %d Elemente in getY-Richtung aufzuteilen.", image.getHeight(), y));
        }
        int imageWidth = image.getWidth() / x;
        int imageHeight = image.getHeight() / y;
        LinkedList<AnimationFrame> frames = new LinkedList<AnimationFrame>();
        for (int j = 0; j < y; ++j) {
            for (int i = 0; i < x; ++i) {
                frames.add(new AnimationFrame(image.getSubimage(i * imageWidth, j * imageHeight, imageWidth, imageHeight), frameDuration));
            }
        }
        return new Animation(frames.toArray(new AnimationFrame[0]), width, height);
    }

    @API
    public static Animation createFromImages(double frameDuration, double width, double height, String ... filepaths) {
        if (frameDuration <= 0.0) {
            throw new RuntimeException("Frame-L\u00e4nge muss gr\u00f6\u00dfer als 1 sein.");
        }
        LinkedList<AnimationFrame> frames = new LinkedList<AnimationFrame>();
        for (String filepath : filepaths) {
            frames.add(new AnimationFrame((BufferedImage)Game.getImages().get(filepath), frameDuration));
        }
        return new Animation(frames.toArray(new AnimationFrame[0]), width, height);
    }

    @API
    public static Animation createFromImagesPrefix(double frameDuration, double width, double height, String directoryPath, String prefix) {
        ArrayList<String> allPaths = new ArrayList<String>();
        File directory = ResourceLoader.loadAsFile(directoryPath);
        if (!directory.isDirectory()) {
            throw new RuntimeException("Der angegebene Pfad war kein Verzeichnis: " + directoryPath);
        }
        File[] children = directory.listFiles();
        if (children != null) {
            for (File file : children) {
                if (file.isDirectory() || !file.getName().startsWith(prefix)) continue;
                allPaths.add(file.getAbsolutePath());
            }
        }
        allPaths.sort(Comparator.naturalOrder());
        if (allPaths.isEmpty()) {
            throw new RuntimeException("Konnte keine Bilder mit Pr\u00e4fix \"" + prefix + "\" im Verzeichnis \"" + directoryPath + "\" finden.");
        }
        return Animation.createFromImages(frameDuration, width, height, allPaths.toArray(new String[0]));
    }

    @API
    public static Animation createFromAnimatedGif(String filepath, double width, double height) {
        GifDecoder gifDecoder = new GifDecoder();
        if (!FileUtil.exists(filepath)) {
            throw new RuntimeException("Filepath doesn\u2019t exist: " + filepath);
        }
        gifDecoder.read(filepath);
        int frameCount = gifDecoder.getFrameCount();
        AnimationFrame[] frames = new AnimationFrame[frameCount];
        for (int i = 0; i < frameCount; ++i) {
            BufferedImage frame = gifDecoder.getFrame(i);
            int durationInMillis = gifDecoder.getDelay(i);
            frames[i] = new AnimationFrame(frame, (double)durationInMillis / 1000.0);
        }
        return new Animation(frames, width, height);
    }
}

