/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureBuilder;
import de.pirckheimer_gymnasium.engine_pi.resources.Container;
import java.awt.Color;
import java.awt.Graphics2D;

public class Grid
extends Actor {
    int cols;
    int rows;
    double size = 1.0;
    double lineThickness = 0.02;
    Color color = Container.colors.getGreen();
    Color background;

    public Grid(int cols, int rows, double size) {
        super(() -> FixtureBuilder.rectangle((double)cols * size, (double)rows * size));
        this.cols = cols;
        this.rows = rows;
        this.size = size;
    }

    public Grid(int cols, int rows) {
        this(cols, rows, 1.0);
    }

    public void setLineThickness(double lineThickness) {
        this.lineThickness = lineThickness;
    }

    @API
    public void setColor(Color color) {
        this.color = color;
    }

    @API
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public void render(Graphics2D g, double pixelPerMeter) {
        int cellSize = (int)Math.round(pixelPerMeter * this.size);
        if (this.background != null) {
            g.setColor(this.background);
            g.fillRect(0, -Math.round(cellSize * this.rows), Math.round(cellSize * this.cols), Math.round(cellSize * this.rows));
        }
        g.setColor(this.color);
        int thickness = (int)Math.round(pixelPerMeter * this.lineThickness);
        if (thickness < 1) {
            thickness = 1;
        }
        int lengthVertical = Math.round(this.rows * cellSize);
        for (int x = 0; x <= this.cols; ++x) {
            g.fillRect(Math.round(x * cellSize), -lengthVertical, thickness, lengthVertical);
        }
        int lengthHorizontal = Math.round(this.cols * cellSize);
        for (int y = 0; y <= this.rows; ++y) {
            g.fillRect(0, -Math.round(y * cellSize), lengthHorizontal, thickness);
        }
    }
}

