/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Tile;
import de.pirckheimer_gymnasium.engine_pi.actor.TileMap;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureBuilder;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class TileContainer
extends Actor
implements TileMap {
    private final Tile[][] tiles;
    private final double tileWidth;
    private final double tileHeight;

    @API
    public TileContainer(int numX, int numY, double tileWidth, double tileHeight) {
        super(() -> FixtureBuilder.rectangle(tileWidth * (double)numX, tileHeight * (double)numY));
        if (numX <= 0 || numY <= 0) {
            throw new IllegalArgumentException("numX und numY m\u00fcssen jeweils > 0 sein.");
        }
        if (tileWidth <= 0.0 || tileHeight <= 0.0) {
            throw new IllegalArgumentException("Breite und H\u00f6he der Tiles m\u00fcssen jeweils > 0 sein.");
        }
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.tiles = new Tile[numX][numY];
    }

    public int getTileCountX() {
        return this.tiles.length;
    }

    public int getTileCountY() {
        return this.tiles[0].length;
    }

    @API
    public TileContainer(int numX, int numY, double tileSize) {
        this(numX, numY, tileSize, tileSize);
    }

    @API
    public void setTile(int x, int y, Tile tile) {
        this.tiles[x][y] = tile;
    }

    @Override
    @Internal
    public void render(Graphics2D g, double pixelPerMeter) {
        AffineTransform ore = g.getTransform();
        double offset = (double)this.tiles[0].length * this.tileHeight * pixelPerMeter;
        g.translate(0.0, -offset);
        for (int x = 0; x < this.tiles.length; ++x) {
            for (int y = 0; y < this.tiles[x].length; ++y) {
                if (this.tiles[x][y] == null) continue;
                double tx = this.tileWidth * (double)x * pixelPerMeter;
                double ty = this.tileHeight * (double)y * pixelPerMeter;
                g.translate(tx, ty);
                this.tiles[x][y].render(g, this.tileWidth * pixelPerMeter, this.tileHeight * pixelPerMeter);
                g.translate(-tx, -ty);
            }
        }
        g.setTransform(ore);
    }

    @Override
    public Tile getTile(int x, int y) {
        return this.tiles[x][y];
    }
}

