/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.event;

import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.event.EventListeners;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.PeriodicTask;
import de.pirckheimer_gymnasium.engine_pi.event.SingleTask;

@API
public interface FrameUpdateListenerContainer {
    public EventListeners<FrameUpdateListener> getFrameUpdateListeners();

    @API
    default public void addFrameUpdateListener(FrameUpdateListener frameUpdateListener) {
        this.getFrameUpdateListeners().add(frameUpdateListener);
    }

    @API
    default public void removeFrameUpdateListener(FrameUpdateListener frameUpdateListener) {
        this.getFrameUpdateListeners().remove(frameUpdateListener);
    }

    @API
    default public void defer(final Runnable runnable) {
        FrameUpdateListener frameUpdateListener = new FrameUpdateListener(){

            @Override
            public void onFrameUpdate(double time) {
                FrameUpdateListenerContainer.this.removeFrameUpdateListener(this);
                runnable.run();
            }
        };
        this.addFrameUpdateListener(frameUpdateListener);
    }

    @API
    default public FrameUpdateListener delay(double timeInSeconds, Runnable runnable) {
        SingleTask singleTask = new SingleTask(timeInSeconds, runnable, this);
        this.addFrameUpdateListener(singleTask);
        return singleTask;
    }

    @API
    default public PeriodicTask repeat(double intervalInSeconds, Runnable runnable) {
        PeriodicTask periodicTask = new PeriodicTask(intervalInSeconds, runnable, this);
        this.addFrameUpdateListener(periodicTask);
        return periodicTask;
    }
}

