/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.event;

import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListenerContainer;

public final class PeriodicTask
implements FrameUpdateListener {
    private double interval;
    private double countdown;
    private Runnable runnable;
    private FrameUpdateListenerContainer container;
    public boolean isPaused;

    public PeriodicTask(double intervalInSeconds, Runnable runnable, FrameUpdateListenerContainer container) {
        this.setInterval(intervalInSeconds);
        this.countdown = intervalInSeconds;
        this.runnable = runnable;
        this.container = container;
    }

    public PeriodicTask(double intervalInSeconds, Runnable runnable) {
        this(intervalInSeconds, runnable, null);
    }

    @API
    public void setInterval(double interval) {
        if (interval <= 0.0) {
            throw new RuntimeException("Das Interval eines periodischen Tasks muss gr\u00f6\u00dfer als 0 sein, war " + interval);
        }
        this.interval = interval;
    }

    @API
    public double getInterval() {
        return this.interval;
    }

    public void pause() {
        this.isPaused = true;
    }

    public void resume() {
        this.isPaused = false;
    }

    public void toggle() {
        if (this.isPaused) {
            this.resume();
        } else {
            this.pause();
        }
    }

    public void unregister() {
        if (this.container == null) {
            throw new RuntimeException("Die periodischen Aufgabe kann nicht angemeldet werden, da sie keine Referenz auf den \u00fcbergeordneten Beh\u00e4lter hat, in dem diese periodische Aufgabe angemeldet wurde.");
        }
        this.container.removeFrameUpdateListener(this);
    }

    @Override
    @Internal
    public void onFrameUpdate(double deltaSeconds) {
        if (this.isPaused) {
            return;
        }
        this.countdown -= deltaSeconds;
        if (this.countdown < 0.0) {
            this.countdown += this.interval;
            this.runnable.run();
        }
    }
}

