/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.resources;

import de.pirckheimer_gymnasium.engine_pi.resources.Codec;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourceLoader;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourcesContainer;
import de.pirckheimer_gymnasium.engine_pi.resources.SoundResource;
import de.pirckheimer_gymnasium.engine_pi.sound.Sound;
import de.pirckheimer_gymnasium.engine_pi.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class SoundsContainer
extends ResourcesContainer<Sound> {
    private static final Logger log = Logger.getLogger(SoundsContainer.class.getName());

    SoundsContainer() {
    }

    public Sound load(SoundResource resource) {
        byte[] data = Codec.decode(resource.getData());
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        try {
            Sound sound = new Sound(input, resource.getName());
            this.add(resource.getName(), sound);
            return sound;
        }
        catch (IOException | UnsupportedAudioFileException e) {
            log.log(Level.SEVERE, "The audio file {0} could not be loaded.", new Object[]{resource.getName()});
            return null;
        }
    }

    @Override
    protected Sound load(URL resourceName) throws Exception {
        try (InputStream is = ResourceLoader.get(resourceName);){
            if (is == null) {
                log.log(Level.SEVERE, "The audio file {0} could not be loaded.", new Object[]{resourceName});
                Sound sound = null;
                return sound;
            }
            Sound sound = new Sound(is, FileUtil.getFileName(resourceName));
            return sound;
        }
    }
}

