/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.sound;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.resources.SoundsContainer;
import de.pirckheimer_gymnasium.engine_pi.sound.LoopedTrack;
import de.pirckheimer_gymnasium.engine_pi.sound.MusicPlayback;
import de.pirckheimer_gymnasium.engine_pi.sound.Sound;
import de.pirckheimer_gymnasium.engine_pi.sound.SoundPlayback;
import de.pirckheimer_gymnasium.engine_pi.sound.Track;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.LineUnavailableException;

public final class Jukebox {
    public static final int DEFAULT_MAX_DISTANCE = 150;
    static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(new ThreadFactory(){
        private int id = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Sound Playback Thread " + ++this.id);
        }
    });
    private static final Logger log = Logger.getLogger(Jukebox.class.getName());
    private int maxDist = 150;
    private MusicPlayback music;
    private final Collection<MusicPlayback> allMusic = ConcurrentHashMap.newKeySet();
    private final Collection<SoundPlayback> sounds = ConcurrentHashMap.newKeySet();
    private static SoundsContainer soundsContainer = Game.getSounds();

    public int getMaxDistance() {
        return this.maxDist;
    }

    public MusicPlayback playMusic(Sound music) {
        return this.playMusic(new LoopedTrack(music));
    }

    public MusicPlayback playMusic(Track track) {
        return this.playMusic(track, null, false, true);
    }

    public MusicPlayback playMusic(Track track, boolean restart) {
        return this.playMusic(track, null, restart, true);
    }

    public MusicPlayback playMusic(Track track, boolean restart, boolean stop) {
        return this.playMusic(track, null, restart, stop);
    }

    public synchronized MusicPlayback playMusic(Track track, Consumer<? super MusicPlayback> config, boolean restart, boolean stop) {
        if (!restart && this.music != null && this.music.isPlaying() && this.music.getTrack().equals(track)) {
            return this.music;
        }
        try {
            MusicPlayback playback = new MusicPlayback(track);
            if (config != null) {
                config.accept(playback);
            }
            if (stop) {
                this.stopMusic();
            }
            this.allMusic.add(playback);
            playback.start();
            this.music = playback;
            return playback;
        }
        catch (IllegalArgumentException | LineUnavailableException e) {
            Jukebox.resourceFailure(e);
            return null;
        }
    }

    public synchronized MusicPlayback getMusic() {
        return this.music;
    }

    public synchronized Collection<MusicPlayback> getAllMusic() {
        return Collections.unmodifiableCollection(this.allMusic);
    }

    public void setMaxDistance(int radius) {
        this.maxDist = radius;
    }

    public synchronized void stopMusic() {
        for (MusicPlayback track : this.allMusic) {
            track.cancel();
        }
    }

    public Sound getSound(String filePath) {
        return (Sound)soundsContainer.get(filePath);
    }

    public SoundPlayback createPlayback(Sound sound, boolean loop) {
        try {
            return new SoundPlayback(sound, loop);
        }
        catch (IllegalArgumentException | LineUnavailableException e) {
            Jukebox.resourceFailure(e);
            return null;
        }
    }

    public SoundPlayback createPlayback(String filePath, boolean loop) {
        return this.createPlayback(this.getSound(filePath), loop);
    }

    void addSound(SoundPlayback playback) {
        this.sounds.add(playback);
    }

    public SoundPlayback playSound(Sound sound, boolean loop) {
        if (sound == null) {
            return null;
        }
        SoundPlayback playback = this.createPlayback(sound, loop);
        if (playback == null) {
            return null;
        }
        playback.start();
        return playback;
    }

    public SoundPlayback playSound(String filePath, boolean loop) {
        return this.playSound(this.getSound(filePath), loop);
    }

    public SoundPlayback playSound(String filePath) {
        return this.playSound(filePath, false);
    }

    private static void resourceFailure(Throwable e) {
        log.log(Level.WARNING, "could not open a line", e);
    }
}

