/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.sound;

import de.pirckheimer_gymnasium.engine_pi.sound.Playback;
import de.pirckheimer_gymnasium.engine_pi.sound.Sound;
import de.pirckheimer_gymnasium.engine_pi.sound.Track;
import javax.sound.sampled.LineUnavailableException;

public class MusicPlayback
extends Playback {
    private final Track track;
    private final Playback.VolumeControl musicVolume;

    MusicPlayback(Track track) throws LineUnavailableException {
        super(track.getFormat());
        this.track = track;
        this.musicVolume = this.createVolumeControl();
        this.musicVolume.set(1.0f);
    }

    @Override
    public void run() {
        try {
            for (Sound sound : this.track) {
                if (!this.play(sound)) continue;
                return;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.finish();
        }
    }

    public Track getTrack() {
        return this.track;
    }

    void setMusicVolume(float volume) {
        this.musicVolume.set(volume);
    }
}

