/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.tweening;

import de.pirckheimer_gymnasium.engine_pi.tweening.TweenEquation;
import de.pirckheimer_gymnasium.engine_pi.tweening.TweenFunction;
import de.pirckheimer_gymnasium.engine_pi.tweening.TweenType;
import de.pirckheimer_gymnasium.engine_pi.tweening.Tweenable;
import java.util.Arrays;

public class Tween {
    private int duration;
    private TweenEquation equation;
    private long started;
    private final float[] startValues;
    private boolean stopped;
    private final Tweenable target;
    private float[] targetValues;
    private final TweenType type;

    public Tween(Tweenable target, TweenType type, int duration) {
        this.target = target;
        this.type = type;
        this.duration = duration;
        this.startValues = this.target.getTweenValues(type);
        this.targetValues = new float[this.startValues.length];
    }

    public Tween begin() {
        this.started = System.nanoTime();
        this.stopped = false;
        return this;
    }

    public Tween ease(TweenEquation easeEquation) {
        this.equation = easeEquation;
        return this;
    }

    public Tween ease(TweenFunction easingFunction) {
        this.equation = easingFunction.getEquation();
        return this;
    }

    public int getDuration() {
        return this.duration;
    }

    public TweenEquation getEquation() {
        return this.equation;
    }

    public long getStartTime() {
        return this.started;
    }

    public float[] getStartValues() {
        return this.startValues;
    }

    public Tweenable getTarget() {
        return this.target;
    }

    public float[] getTargetValues() {
        return this.targetValues;
    }

    public TweenType getType() {
        return this.type;
    }

    public boolean hasStopped() {
        return this.stopped;
    }

    public Tween reset() {
        this.getTarget().setTweenValues(this.getType(), this.startValues);
        return this;
    }

    public Tween resume() {
        this.stopped = false;
        return this;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public Tween stop() {
        this.stopped = true;
        return this;
    }

    public Tween target(float ... targetValues) {
        if (this.getStartValues().length == 0 || targetValues.length == 0) {
            return this;
        }
        this.targetValues = Arrays.copyOf(targetValues, targetValues.length);
        return this;
    }

    public Tween targetRelative(float ... targetValues) {
        if (this.getStartValues().length == 0 || targetValues.length == 0) {
            return this;
        }
        this.targetValues = new float[targetValues.length];
        for (int i = 0; i < targetValues.length; ++i) {
            this.targetValues[i] = this.getStartValues()[i] + targetValues[i];
        }
        return this;
    }
}

