/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.util;

import de.pirckheimer_gymnasium.engine_pi.util.ColorUtil;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;

public class ColorSchema {
    private Color yellow;
    private Color orange;
    private Color red;
    private Color purple;
    private Color blue;
    private Color green;
    Color white = Color.WHITE;
    Color black = Color.BLACK;

    public ColorSchema(Color yellow, Color orange, Color red, Color purple, Color blue, Color green) {
        this.yellow = yellow;
        this.orange = orange;
        this.red = red;
        this.purple = purple;
        this.blue = blue;
        this.green = green;
    }

    private Color mix(Color color1, Color color2, double factor) {
        return ColorUtil.interpolate(color1, color2, factor);
    }

    private Color mix(Color color1, Color color2) {
        return this.mix(color1, color2, 0.5);
    }

    public Color getYellow() {
        return this.yellow;
    }

    public Color getYellowOrange() {
        return this.mix(this.yellow, this.orange);
    }

    public Color getOrange() {
        return this.orange;
    }

    public Color getOrangeRed() {
        return this.mix(this.orange, this.red);
    }

    public Color getRed() {
        return this.red;
    }

    public Color getRedPurple() {
        return this.mix(this.red, this.purple);
    }

    public Color getPurple() {
        return this.purple;
    }

    public Color getPurpleBlue() {
        return this.mix(this.purple, this.blue);
    }

    public Color getBlue() {
        return this.blue;
    }

    public Color getBlueGreen() {
        return this.mix(this.blue, this.green);
    }

    public Color getGreen() {
        return this.green;
    }

    public Color getYellowGreen() {
        return this.mix(this.yellow, this.green);
    }

    public Color getBrown() {
        return this.mix(this.red, this.green, 0.35);
    }

    public Map<String, Color> getAll() {
        LinkedHashMap<String, Color> map = new LinkedHashMap<String, Color>();
        map.put("yellow", this.getYellow());
        map.put("yelloworange", this.getYellowOrange());
        map.put("orange", this.getOrange());
        map.put("orangered", this.getOrangeRed());
        map.put("red", this.getRed());
        map.put("redpurple", this.getRedPurple());
        map.put("purple", this.getPurple());
        map.put("purpleblue", this.getPurpleBlue());
        map.put("blue", this.getBlue());
        map.put("bluegreen", this.getBlueGreen());
        map.put("green", this.getGreen());
        map.put("yellowgreen", this.getYellowGreen());
        map.put("brown", this.getBrown());
        return map;
    }

    public static ColorSchema getGnomeColorSchema() {
        return new ColorSchema(new Color(246, 211, 45), new Color(255, 120, 0), new Color(224, 27, 36), new Color(145, 65, 172), new Color(53, 132, 228), new Color(51, 209, 122));
    }
}

