/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.resources;

import de.pirckheimer_gymnasium.engine_pi.resources.ColorSchema;
import de.pirckheimer_gymnasium.engine_pi.resources.Container;
import de.pirckheimer_gymnasium.engine_pi.util.ColorUtil;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;

public class ColorContainer
implements Container<Color> {
    private final Map<String, Color> resources = new LinkedHashMap<String, Color>();

    @Override
    public Color add(String name, Color color) {
        this.resources.put(name, color);
        return color;
    }

    public void addSchema(ColorSchema schema) {
        this.add("yellow", schema.getYellow());
        this.add("gold", schema.getGold());
        this.add("orange", schema.getOrange());
        this.add("brick", schema.getBrick());
        this.add("red", schema.getRed());
        this.add("pink", schema.getPink());
        this.add("purple", schema.getPurple());
        this.add("indigo", schema.getIndigo());
        this.add("blue", schema.getBlue());
        this.add("cyan", schema.getCyan());
        this.add("green", schema.getGreen());
        this.add("lime", schema.getLime());
        this.add("brown", schema.getBrown());
        this.add("white", schema.getWhite());
        this.add("gray", schema.getGray());
        this.add("black", schema.getBlack());
    }

    public Map<String, Color> getAll() {
        return this.resources;
    }

    @Override
    public void clear() {
        this.resources.clear();
    }

    @Override
    public Color get(String name) {
        Color color = this.resources.get(name);
        if (color == null && ColorUtil.isHexColorString(name)) {
            return ColorUtil.decode(name);
        }
        return color;
    }
}

