/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.resources;

import de.pirckheimer_gymnasium.engine_pi.util.ColorUtil;
import java.awt.Color;

public class ColorSchema {
    private Color yellow;
    private Color gold;
    private Color orange;
    private Color brick;
    private Color red;
    private Color pink;
    private Color purple;
    private Color indigo;
    private Color blue;
    private Color cyan;
    private Color green;
    private Color lime;
    private Color brown;
    Color white = Color.WHITE;
    Color gray = Color.GRAY;
    Color black = Color.BLACK;

    public ColorSchema(Color yellow, Color red, Color blue) {
        this.yellow = yellow;
        this.red = red;
        this.blue = blue;
    }

    public ColorSchema(Color yellow, Color orange, Color red, Color purple, Color blue, Color green) {
        this(yellow, red, blue);
        this.orange = orange;
        this.purple = purple;
        this.green = green;
    }

    public ColorSchema(Color yellow, Color orange, Color red, Color purple, Color blue, Color green, Color brown) {
        this(yellow, orange, red, purple, blue, green);
        this.brown = brown;
    }

    private Color mix(Color color1, Color color2, double factor) {
        return ColorUtil.interpolate(color1, color2, factor);
    }

    private Color mix(Color color1, Color color2) {
        return this.mix(color1, color2, 0.5);
    }

    public Color getYellow() {
        return this.yellow;
    }

    public void setYellow(Color yellow) {
        this.yellow = yellow;
    }

    public Color getGold() {
        if (this.gold == null) {
            this.gold = this.mix(this.getYellow(), this.getOrange());
        }
        return this.gold;
    }

    public void setGold(Color gold) {
        this.gold = gold;
    }

    public Color getOrange() {
        if (this.orange == null) {
            this.orange = this.mix(this.getYellow(), this.getRed());
        }
        return this.orange;
    }

    public void setOrange(Color orange) {
        this.orange = orange;
    }

    public Color getBrick() {
        if (this.brick == null) {
            this.brick = this.mix(this.getOrange(), this.getRed());
        }
        return this.brick;
    }

    public void setBrick(Color brick) {
        this.brick = brick;
    }

    public Color getRed() {
        return this.red;
    }

    public void setRed(Color red) {
        this.red = red;
    }

    public Color getPink() {
        if (this.pink == null) {
            this.pink = this.mix(this.getRed(), this.getPurple());
        }
        return this.pink;
    }

    public void setPink(Color pink) {
        this.pink = pink;
    }

    public Color getPurple() {
        if (this.purple == null) {
            this.purple = this.mix(this.getRed(), this.getBlue());
            return this.purple;
        }
        return this.purple;
    }

    public void setPurple(Color purple) {
        this.purple = purple;
    }

    public Color getIndigo() {
        if (this.indigo == null) {
            this.indigo = this.mix(this.getPurple(), this.getBlue());
        }
        return this.indigo;
    }

    public void setIndigo(Color indigo) {
        this.indigo = indigo;
    }

    public Color getBlue() {
        return this.blue;
    }

    public void setBlue(Color blue) {
        this.blue = blue;
    }

    public Color getCyan() {
        if (this.cyan == null) {
            this.cyan = this.mix(this.getBlue(), this.getGreen());
        }
        return this.cyan;
    }

    public void setCyan(Color cyan) {
        this.cyan = cyan;
    }

    public Color getGreen() {
        if (this.green == null) {
            this.green = this.mix(this.getYellow(), this.getBlue());
        }
        return this.green;
    }

    public void setGreen(Color green) {
        this.green = green;
    }

    public Color getLime() {
        if (this.lime == null) {
            this.lime = this.mix(this.getYellow(), this.getGreen());
        }
        return this.lime;
    }

    public void setLime(Color lime) {
        this.lime = lime;
    }

    public Color getBrown() {
        if (this.brown == null) {
            this.brown = this.mix(this.getRed(), this.getGreen(), 0.35);
        }
        return this.brown;
    }

    public void set(Color brown) {
        this.brown = brown;
    }

    public Color getWhite() {
        return this.white;
    }

    public void setWhite(Color white) {
        this.white = white;
    }

    public Color getGray() {
        return this.gray;
    }

    public void setGray(Color gray) {
        this.gray = gray;
    }

    public Color getBlack() {
        return this.black;
    }

    public void setBlack(Color black) {
        this.black = black;
    }

    public static ColorSchema getGnomeColorSchema() {
        return new ColorSchema(new Color(246, 211, 45), new Color(255, 120, 0), new Color(224, 27, 36), new Color(145, 65, 172), new Color(53, 132, 228), new Color(51, 209, 122), new Color(152, 106, 68));
    }
}

