/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.resources;

import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourceLoader;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@API
public final class FontLoader {
    private static final int DEFAULT_SIZE = 12;
    public static final String[] systemFonts;
    private static final Map<String, Font> userFonts;

    @API
    public static boolean isSystemFont(String fontName) {
        for (String s : systemFonts) {
            if (!s.equals(fontName)) continue;
            return true;
        }
        return false;
    }

    @API
    public static String[] getSystemFonts() {
        return (String[])systemFonts.clone();
    }

    @API
    public static Font loadByName(String fontName) {
        return new Font(fontName, 0, 12);
    }

    @API
    public static Font loadFromFile(String filename) {
        Font font;
        block9: {
            if (userFonts.containsKey(filename)) {
                return userFonts.get(filename);
            }
            InputStream stream = ResourceLoader.loadAsStream(filename);
            try {
                Font customFont = Font.createFont(0, stream).deriveFont(0);
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                ge.registerFont(customFont);
                userFonts.put(filename, customFont);
                font = customFont;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FontFormatException | IOException e) {
                    throw new RuntimeException("Die angegebene Schriftart konnte nicht geladen werden: " + filename);
                }
            }
            stream.close();
        }
        return font;
    }

    private FontLoader() {
    }

    static {
        userFonts = new ConcurrentHashMap<String, Font>();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        systemFonts = ge.getAvailableFontFamilyNames();
    }
}

