/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.sound;

import de.pirckheimer_gymnasium.engine_pi.util.StreamUtilities;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class Sound {
    private AudioFormat format;
    private final String name;
    private AudioInputStream stream;
    private byte[] streamData;
    private byte[] data;

    public Sound(InputStream is, String name) throws IOException, UnsupportedAudioFileException {
        this.name = name;
        this.data = StreamUtilities.getBytes(is);
        AudioInputStream in = AudioSystem.getAudioInputStream(is);
        if (in != null) {
            AudioFormat baseFormat = in.getFormat();
            AudioFormat decodedFormat = Sound.getOutFormat(baseFormat);
            this.stream = in = AudioSystem.getAudioInputStream(decodedFormat, in);
            this.streamData = StreamUtilities.getBytes(this.stream);
            this.format = this.stream.getFormat();
        }
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getRawData() {
        return this.data;
    }

    byte[] getStreamData() {
        if (this.streamData == null) {
            return new byte[0];
        }
        return (byte[])this.streamData.clone();
    }

    private static AudioFormat getOutFormat(AudioFormat inFormat) {
        int ch = inFormat.getChannels();
        float rate = inFormat.getSampleRate();
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, rate, 16, ch, ch * 2, rate, false);
    }

    public String toString() {
        return this.getName();
    }
}

