/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Bounds;
import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Layer;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.BodyType;
import de.pirckheimer_gymnasium.engine_pi.actor.DistanceJoint;
import de.pirckheimer_gymnasium.engine_pi.actor.PrismaticJoint;
import de.pirckheimer_gymnasium.engine_pi.actor.RevoluteJoint;
import de.pirckheimer_gymnasium.engine_pi.actor.RopeJoint;
import de.pirckheimer_gymnasium.engine_pi.actor.WeldJoint;
import de.pirckheimer_gymnasium.engine_pi.animation.ValueAnimator;
import de.pirckheimer_gymnasium.engine_pi.animation.interpolation.EaseInOutDouble;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionEvent;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionListener;
import de.pirckheimer_gymnasium.engine_pi.event.EventListenerBundle;
import de.pirckheimer_gymnasium.engine_pi.event.EventListeners;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.MouseScrollListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseScrollListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureBuilder;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureData;
import de.pirckheimer_gymnasium.engine_pi.physics.NullHandler;
import de.pirckheimer_gymnasium.engine_pi.physics.PhysicsData;
import de.pirckheimer_gymnasium.engine_pi.physics.PhysicsHandler;
import de.pirckheimer_gymnasium.engine_pi.physics.WorldHandler;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.dynamics.joints.RopeJointDef;
import org.jbox2d.dynamics.joints.WeldJointDef;

public abstract class Actor
implements KeyStrokeListenerRegistration,
MouseClickListenerRegistration,
MouseScrollListenerRegistration,
FrameUpdateListenerRegistration {
    private boolean visible = true;
    private int layerPosition = 1;
    private double opacity = 1.0;
    private PhysicsHandler physicsHandler;
    private final EventListenerBundle listeners = new EventListenerBundle();
    private final EventListeners<KeyStrokeListener> keyStrokeListeners = new EventListeners(this.createParentSupplier(Layer::getKeyStrokeListeners));
    private final EventListeners<MouseClickListener> mouseClickListeners = new EventListeners(this.createParentSupplier(Layer::getMouseClickListeners));
    private final EventListeners<MouseScrollListener> mouseScrollListeners = new EventListeners(this.createParentSupplier(Layer::getMouseScrollListeners));
    private final EventListeners<FrameUpdateListener> frameUpdateListeners = new EventListeners(this.createParentSupplier(Layer::getFrameUpdateListeners));

    private <T> Supplier<T> createParentSupplier(Function<Layer, T> supplier) {
        return () -> {
            Layer layer = this.getLayer();
            if (layer == null) {
                return null;
            }
            return supplier.apply(layer);
        };
    }

    public Actor(Supplier<FixtureData> defaultFixtureSupplier) {
        this.physicsHandler = new NullHandler(new PhysicsData(() -> Collections.singletonList((FixtureData)defaultFixtureSupplier.get())));
        EventListeners.registerListeners(this);
    }

    @API
    public final void addMountListener(Runnable listener) {
        this.listeners.mount.add(listener);
        if (this.isMounted()) {
            listener.run();
        }
    }

    @API
    public final void removeMountListener(Runnable listener) {
        this.listeners.mount.remove(listener);
    }

    @API
    public final void addUnmountListener(Runnable listener) {
        this.listeners.unmount.add(listener);
    }

    @API
    public final void removeUnmountListener(Runnable listener) {
        this.listeners.unmount.remove(listener);
    }

    @API
    public final void setLayerPosition(int position) {
        this.layerPosition = position;
    }

    @API
    public final int getLayerPosition() {
        return this.layerPosition;
    }

    @API
    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    @API
    public final boolean isVisible() {
        return this.visible;
    }

    @API
    public final double getOpacity() {
        return this.opacity;
    }

    @API
    public final void setOpacity(double opacity) {
        this.opacity = opacity;
    }

    @API
    public final boolean contains(Vector point) {
        return this.physicsHandler.contains(point);
    }

    @API
    public final boolean overlaps(Actor other) {
        Body a = this.physicsHandler.getBody();
        Body b = other.getPhysicsHandler().getBody();
        return WorldHandler.isBodyCollision(a, b);
    }

    public final List<CollisionEvent<Actor>> getCollisions() {
        return this.physicsHandler.getCollisions();
    }

    @API
    public final void setBodyType(BodyType type) {
        Objects.requireNonNull(type, "Typ darf nicht null sein");
        this.physicsHandler.setType(type);
    }

    @API
    public final void makeStatic() {
        this.setBodyType(BodyType.STATIC);
    }

    @API
    public final void makeDynamic() {
        this.setBodyType(BodyType.DYNAMIC);
    }

    @API
    public final void makeKinematic() {
        this.setBodyType(BodyType.KINEMATIC);
    }

    @API
    public final void makeSensor() {
        this.setBodyType(BodyType.SENSOR);
    }

    @API
    public final void makeParticle() {
        this.setBodyType(BodyType.PARTICLE);
    }

    @API
    public final BodyType getBodyType() {
        return this.physicsHandler.getType();
    }

    @API
    public final void setFixtures(String shapeCode) {
        this.setFixtures(FixtureBuilder.fromString(shapeCode));
    }

    @API
    public final void setFixture(Supplier<FixtureData> fixtureSupplier) {
        this.setFixtures(() -> Collections.singletonList((FixtureData)fixtureSupplier.get()));
    }

    @API
    public final void setFixtures(Supplier<List<FixtureData>> fixturesSupplier) {
        this.physicsHandler.setFixtures(fixturesSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public final void renderBasic(Graphics2D g, Bounds r, double pixelPerMeter) {
        if (this.visible && this.isWithinBounds(r)) {
            Composite composite;
            double rotation = this.physicsHandler.getRotation();
            Vector position = this.physicsHandler.getPosition();
            AffineTransform transform = g.getTransform();
            g.rotate(-Math.toRadians(rotation), position.getX() * pixelPerMeter, -position.getY() * pixelPerMeter);
            g.translate(position.getX() * pixelPerMeter, -position.getY() * pixelPerMeter);
            if (this.opacity != 1.0) {
                composite = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, (float)this.opacity));
            } else {
                composite = null;
            }
            this.render(g, pixelPerMeter);
            if (Game.isDebug()) {
                Actor actor = this;
                synchronized (actor) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    Body body = this.physicsHandler.getBody();
                    if (body != null) {
                        Fixture fixture = body.m_fixtureList;
                        while (fixture != null && fixture.m_shape != null) {
                            Actor.renderShape(fixture.m_shape, g, pixelPerMeter);
                            fixture = fixture.m_next;
                        }
                    }
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
            }
            if (composite != null) {
                g.setComposite(composite);
            }
            g.setTransform(transform);
        }
    }

    @Internal
    private static void renderShape(Shape shape, Graphics2D g, double pixelPerMeter) {
        if (shape == null) {
            return;
        }
        AffineTransform pre = g.getTransform();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(Color.YELLOW);
        g.drawOval(-1, -1, 2, 2);
        g.setColor(Color.RED);
        if (shape instanceof PolygonShape) {
            PolygonShape polygonShape = (PolygonShape)shape;
            Vec2[] vec2s = polygonShape.getVertices();
            int[] xs = new int[polygonShape.getVertexCount()];
            int[] ys = new int[polygonShape.getVertexCount()];
            for (int i = 0; i < xs.length; ++i) {
                xs[i] = (int)((double)vec2s[i].x * pixelPerMeter);
                ys[i] = -1 * (int)((double)vec2s[i].y * pixelPerMeter);
            }
            g.drawPolygon(xs, ys, xs.length);
        } else if (shape instanceof CircleShape) {
            CircleShape circleShape = (CircleShape)shape;
            double diameter = circleShape.m_radius * 2.0f;
            g.drawOval((int)((double)(circleShape.m_p.x - circleShape.m_radius) * pixelPerMeter), (int)((double)(-circleShape.m_p.y - circleShape.m_radius) * pixelPerMeter), (int)(diameter * pixelPerMeter), (int)(diameter * pixelPerMeter));
        } else {
            throw new RuntimeException("Konnte die Shape (" + shape + ") nicht rendern, unerwartete Shape");
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setTransform(pre);
    }

    @Internal
    private boolean isWithinBounds(Bounds bounds) {
        return true;
    }

    @Internal
    public final PhysicsHandler getPhysicsHandler() {
        return this.physicsHandler;
    }

    @API
    public final <E extends Actor> void addCollisionListener(E collider, CollisionListener<E> listener) {
        WorldHandler.addSpecificCollisionListener(this, collider, listener);
    }

    @API
    public final <E extends Actor> void addCollisionListener(final Class<E> clazz, final CollisionListener<E> listener) {
        WorldHandler.addGenericCollisionListener(new CollisionListener<Actor>(){

            @Override
            public void onCollision(CollisionEvent<Actor> collisionEvent) {
                if (clazz.isInstance(collisionEvent.getColliding())) {
                    listener.onCollision(collisionEvent);
                }
            }

            @Override
            public void onCollisionEnd(CollisionEvent<Actor> collisionEvent) {
                if (clazz.isInstance(collisionEvent.getColliding())) {
                    listener.onCollisionEnd(collisionEvent);
                }
            }
        }, this);
    }

    @API
    public final void addCollisionListener(CollisionListener<Actor> listener) {
        WorldHandler.addGenericCollisionListener(listener, this);
    }

    @Internal
    public abstract void render(Graphics2D var1, double var2);

    @Internal
    public final void setPhysicsHandler(PhysicsHandler handler) {
        WorldHandler worldHandler = handler.getWorldHandler();
        WorldHandler previousWorldHandler = this.physicsHandler.getWorldHandler();
        if (worldHandler == null) {
            if (previousWorldHandler == null) {
                return;
            }
            Layer layer = previousWorldHandler.getLayer();
            this.keyStrokeListeners.invoke(layer::removeKeyStrokeListener);
            this.mouseClickListeners.invoke(layer::removeMouseClickListener);
            this.mouseScrollListeners.invoke(layer::removeMouseScrollListener);
            this.frameUpdateListeners.invoke(layer::removeFrameUpdateListener);
            this.listeners.unmount.invoke(Runnable::run);
            this.physicsHandler = handler;
        } else {
            if (previousWorldHandler != null) {
                return;
            }
            this.physicsHandler = handler;
            Layer layer = worldHandler.getLayer();
            this.listeners.mount.invoke(Runnable::run);
            this.keyStrokeListeners.invoke(layer::addKeyStrokeListener);
            this.mouseClickListeners.invoke(layer::addMouseClickListener);
            this.mouseScrollListeners.invoke(layer::addMouseScrollListener);
            this.frameUpdateListeners.invoke(layer::addFrameUpdateListener);
        }
    }

    public final Layer getLayer() {
        WorldHandler worldHandler = this.physicsHandler.getWorldHandler();
        if (worldHandler == null) {
            return null;
        }
        return worldHandler.getLayer();
    }

    public final void remove() {
        Layer layer = this.getLayer();
        if (layer != null) {
            layer.remove(this);
        }
    }

    @API
    public final EventListenerBundle getListenerBundle() {
        return this.listeners;
    }

    @Override
    @API
    public final EventListeners<KeyStrokeListener> getKeyStrokeListeners() {
        return this.keyStrokeListeners;
    }

    @Override
    @API
    public final EventListeners<MouseClickListener> getMouseClickListeners() {
        return this.mouseClickListeners;
    }

    @Override
    @API
    public final EventListeners<MouseScrollListener> getMouseScrollListeners() {
        return this.mouseScrollListeners;
    }

    @Override
    @API
    public final EventListeners<FrameUpdateListener> getFrameUpdateListeners() {
        return this.frameUpdateListeners;
    }

    @API
    public final void setRotationLocked(boolean rotationLocked) {
        this.physicsHandler.setRotationLocked(rotationLocked);
    }

    @API
    public final boolean isRotationLocked() {
        return this.physicsHandler.isRotationLocked();
    }

    @API
    public final double getMass() {
        return this.physicsHandler.getMass();
    }

    @API
    public final void setDensity(double density) {
        this.physicsHandler.setDensity(density);
    }

    @API
    public final double getDensity() {
        return this.physicsHandler.getDensity();
    }

    @API
    public final void setGravityScale(double factor) {
        this.physicsHandler.setGravityScale(factor);
    }

    @API
    public final double getGravityScale() {
        return this.physicsHandler.getGravityScale();
    }

    @API
    public final void setFriction(double friction) {
        this.physicsHandler.setFriction(friction);
    }

    @API
    public final double getFriction() {
        return this.physicsHandler.getFriction();
    }

    @API
    public final void setAngularDamping(double damping) {
        this.physicsHandler.setAngularDamping(damping);
    }

    @API
    public final double getAngularDamping() {
        return this.physicsHandler.getAngularDamping();
    }

    @API
    public final void setLinearDamping(double damping) {
        this.physicsHandler.setLinearDamping(damping);
    }

    @API
    public final double getLinearDamping() {
        return this.physicsHandler.getLinearDamping();
    }

    @API
    public final void setVelocity(Vector velocity) {
        if (velocity.isNaN()) {
            return;
        }
        this.physicsHandler.setVelocity(velocity);
    }

    @API
    public final Vector getVelocity() {
        return this.physicsHandler.getVelocity();
    }

    @API
    public final double getAngularVelocity() {
        return this.physicsHandler.getAngularVelocity();
    }

    @API
    public final void setAngularVelocity(double rotationsPerSecond) {
        if (Double.isNaN(rotationsPerSecond)) {
            return;
        }
        this.physicsHandler.setAngularVelocity(rotationsPerSecond);
    }

    @API
    public final void setElasticity(double elasticity) {
        if (Double.isNaN(elasticity)) {
            throw new RuntimeException("Ung\u00fcltige Sto\u00dfzahl: " + elasticity);
        }
        this.physicsHandler.setRestitution(elasticity);
    }

    @API
    public final double getElasticity() {
        return this.physicsHandler.getRestitution();
    }

    @API
    public final void applyTorque(double torque) {
        if (Double.isNaN(torque)) {
            return;
        }
        this.physicsHandler.applyTorque(torque);
    }

    public final void applyRotationImpulse(double impulse) {
        if (Double.isNaN(impulse)) {
            return;
        }
        this.physicsHandler.applyRotationImpulse(impulse);
    }

    @API
    public final void applyForce(Vector force) {
        if (force.isNaN()) {
            return;
        }
        this.physicsHandler.applyForce(force);
    }

    public final void applyForce(double forceX, double forceY) {
        this.applyForce(new Vector(forceX, forceY));
    }

    @API
    public final void applyForce(Vector force, Vector globalPoint) {
        if (force.isNaN() || globalPoint.isNaN()) {
            return;
        }
        this.physicsHandler.applyForce(force, globalPoint);
    }

    @API
    public final void applyImpulse(Vector impulse) {
        if (impulse.isNaN()) {
            return;
        }
        this.physicsHandler.applyImpulse(impulse, this.physicsHandler.getCenter());
    }

    public final void applyImpulse(double impulseX, double impulseY) {
        this.applyImpulse(new Vector(impulseX, impulseY));
    }

    @API
    public final void applyImpulse(Vector impulse, Vector globalPoint) {
        this.physicsHandler.applyImpulse(impulse, globalPoint);
    }

    @API
    public final void resetMovement() {
        this.physicsHandler.resetMovement();
    }

    @API
    public final boolean isGrounded() {
        return this.physicsHandler.isGrounded();
    }

    @API
    public final RevoluteJoint createRevoluteJoint(Actor other, Vector anchor) {
        return WorldHandler.createJoint(this, other, (world, a, b) -> {
            RevoluteJointDef def = new RevoluteJointDef();
            def.initialize(a, b, this.getPosition().add(anchor).toVec2());
            def.collideConnected = false;
            return (org.jbox2d.dynamics.joints.RevoluteJoint)world.createJoint(def);
        }, new RevoluteJoint());
    }

    @API
    public final RopeJoint createRopeJoint(Actor other, Vector anchorThis, Vector anchorOther, double ropeLength) {
        return WorldHandler.createJoint(this, other, (world, a, b) -> {
            RopeJointDef def = new RopeJointDef();
            def.bodyA = a;
            def.bodyB = b;
            def.localAnchorA.set(anchorThis.toVec2());
            def.localAnchorB.set(anchorOther.toVec2());
            def.collideConnected = true;
            def.maxLength = (float)ropeLength;
            return (org.jbox2d.dynamics.joints.RopeJoint)world.createJoint(def);
        }, new RopeJoint());
    }

    @API
    public final PrismaticJoint createPrismaticJoint(Actor other, Vector anchor, double axisAngle) {
        return WorldHandler.createJoint(this, other, (world, a, b) -> {
            double angleInRadians = Math.toRadians(axisAngle);
            PrismaticJointDef def = new PrismaticJointDef();
            def.initialize(a, b, this.getPosition().add(anchor).toVec2(), new Vec2((float)Math.cos(angleInRadians), (float)Math.sin(angleInRadians)));
            def.collideConnected = false;
            return (org.jbox2d.dynamics.joints.PrismaticJoint)world.createJoint(def);
        }, new PrismaticJoint());
    }

    @API
    public final DistanceJoint createDistanceJoint(Actor other, Vector anchorThis, Vector anchorOther) {
        return WorldHandler.createJoint(this, other, (world, a, b) -> {
            DistanceJointDef def = new DistanceJointDef();
            def.bodyA = a;
            def.bodyB = b;
            def.localAnchorA.set(anchorThis.toVec2());
            def.localAnchorB.set(anchorOther.toVec2());
            Vector distanceBetweenBothActors = this.getPosition().add(anchorThis).getDistance(other.getPosition().add(anchorOther));
            def.length = (float)distanceBetweenBothActors.getLength();
            return (org.jbox2d.dynamics.joints.DistanceJoint)world.createJoint(def);
        }, new DistanceJoint());
    }

    @API
    public final WeldJoint createWeldJoint(Actor other, Vector anchorThis, Vector anchorOther) {
        return WorldHandler.createJoint(this, other, (world, a, b) -> {
            WeldJointDef def = new WeldJointDef();
            def.bodyA = a;
            def.bodyB = b;
            def.localAnchorA.set(anchorThis.toVec2());
            def.localAnchorB.set(anchorOther.toVec2());
            return (org.jbox2d.dynamics.joints.WeldJoint)world.createJoint(def);
        }, new WeldJoint());
    }

    @API
    public final void setPosition(double x, double y) {
        this.setPosition(new Vector(x, y));
    }

    @API
    public final void setPosition(Vector position) {
        this.moveBy(position.subtract(this.getPosition()));
    }

    @API
    public final void moveBy(Vector vector) {
        this.physicsHandler.moveBy(vector);
    }

    @API
    public final void moveBy(double dX, double dY) {
        this.moveBy(new Vector(dX, dY));
    }

    @API
    public final void setCenter(double x, double y) {
        this.setCenter(new Vector(x, y));
    }

    @API
    public final void setCenter(Vector center) {
        this.moveBy(this.getCenter().negate().add(center));
    }

    @API
    public final double getX() {
        return this.getPosition().getX();
    }

    @API
    public final void setX(double x) {
        this.moveBy(x - this.getX(), 0.0);
    }

    @API
    public final double getY() {
        return this.getPosition().getY();
    }

    @API
    public final void setY(double y) {
        this.moveBy(0.0, y - this.getY());
    }

    @API
    public final Vector getCenter() {
        return this.physicsHandler.getCenter();
    }

    @API
    public final Vector getCenterRelative() {
        return this.getCenter().subtract(this.getPosition());
    }

    @API
    public final Vector getPosition() {
        return this.physicsHandler.getPosition();
    }

    @API
    public final void rotateBy(double degree) {
        this.physicsHandler.rotateBy(degree);
    }

    @API
    public final double getRotation() {
        return this.physicsHandler.getRotation();
    }

    @API
    public final void setRotation(double degree) {
        this.physicsHandler.setRotation(degree);
    }

    @API
    public final boolean isMounted() {
        return this.getLayer() != null;
    }

    @API
    public final ValueAnimator<Double> animateParticle(double lifetime) {
        this.setBodyType(BodyType.PARTICLE);
        this.setOpacity(1.0);
        ValueAnimator<Double> animator = this.animateOpacity(lifetime, 0.0);
        animator.addCompletionListener(value -> this.remove());
        return animator;
    }

    @API
    public final ValueAnimator<Double> animateOpacity(double time, double toOpacityValue) {
        ValueAnimator<Double> animator = new ValueAnimator<Double>(time, this::setOpacity, new EaseInOutDouble(this.getOpacity(), toOpacityValue), this);
        this.addFrameUpdateListener(animator);
        return animator;
    }

    @Internal
    static void assertPositiveWidthAndHeight(double width, double height) {
        if (width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException("Breite und H\u00f6he m\u00fcssen gr\u00f6\u00dfer 0 sein! " + width + " / " + height);
        }
    }

    public void awake() {
        this.physicsHandler.setAwake(true);
    }

    public void sleep() {
        this.physicsHandler.setAwake(false);
    }
}

