/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.actor.Geometry;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureBuilder;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureData;
import java.awt.Graphics2D;
import java.util.function.Supplier;

public class Rectangle
extends Geometry {
    private double width;
    private double height;
    private double borderRadius;

    public Rectangle(double width, double height) {
        this(width, height, () -> FixtureBuilder.rectangle(width, height));
        this.setColor(Resources.colorSchema.getBlue());
    }

    public Rectangle(double width, double height, Supplier<FixtureData> shapeSupplier) {
        super(shapeSupplier);
        Rectangle.assertPositiveWidthAndHeight(width, height);
        this.width = width;
        this.height = height;
    }

    public Rectangle() {
        this(1.0, 1.0);
    }

    @API
    public double getWidth() {
        return this.width;
    }

    @API
    public void setWidth(double width) {
        this.setSize(width, this.getHeight());
    }

    @API
    public double getHeight() {
        return this.height;
    }

    @API
    public void setHeight(double height) {
        this.setSize(this.getWidth(), height);
    }

    @API
    public void setSize(double width, double height) {
        Rectangle.assertPositiveWidthAndHeight(width, height);
        this.width = width;
        this.height = height;
        this.setFixture(() -> FixtureBuilder.rectangle(width, height));
    }

    @API
    public double getBorderRadius() {
        return this.borderRadius;
    }

    @API
    public void setBorderRadius(double percent) {
        if (percent < 0.0 || percent > 1.0) {
            throw new IllegalArgumentException("Borderradius kann nur zwischen 0 und 1 sein. War " + percent);
        }
        this.borderRadius = percent;
    }

    @Override
    public void render(Graphics2D g, double pixelPerMeter) {
        g.setColor(this.getColor());
        if (this.borderRadius == 0.0) {
            g.fillRect(0, (int)(-this.height * pixelPerMeter), (int)(this.width * pixelPerMeter), (int)(this.height * pixelPerMeter));
        } else {
            int borderRadius = (int)(Math.min(this.width, this.height) * pixelPerMeter * this.borderRadius);
            g.fillRoundRect(0, (int)(-this.height * pixelPerMeter), (int)(this.width * pixelPerMeter), (int)(this.height * pixelPerMeter), borderRadius, borderRadius);
        }
    }
}

