/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.actor.Tile;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

@API
public interface TileMap {
    @API
    public static Tile createFromImage(String path) {
        return TileMap.createFromImage((BufferedImage)Resources.images.get(path));
    }

    public static Tile createFromImage(BufferedImage image) {
        return (g, width, height) -> {
            AffineTransform pre = g.getTransform();
            g.scale(width / (double)image.getWidth(), height / (double)image.getHeight());
            g.drawImage(image, null, 0, 0);
            g.setTransform(pre);
        };
    }

    public static TileMap createFromImage(String path, int sizeX, int sizeY) {
        BufferedImage image = (BufferedImage)Resources.images.get(path);
        if (image.getWidth() % sizeX != 0) {
            throw new IllegalArgumentException(String.format("Kann die Kacheln mit der Breite von %spx nicht aus der Bilddatei (%s) ausschneiden, da die Bildbreite (%spx) ein Vielfaches der Kachelbreite sein muss.", sizeX, path, image.getWidth()));
        }
        if (image.getHeight() % sizeY != 0) {
            throw new IllegalArgumentException(String.format("Kann die Kacheln mit der H\u00f6he von %spx nicht aus der Bilddatei (%s) ausschneiden, da die Bildh\u00f6he (%spx) ein Vielfaches der Kachelh\u00f6he sein muss.", sizeY, path, image.getHeight()));
        }
        Tile[][] tiles = new Tile[image.getWidth() / sizeX][image.getHeight() / sizeY];
        for (int posX = 0; posX < image.getWidth(); posX += sizeX) {
            for (int posY = 0; posY < image.getHeight(); posY += sizeY) {
                tiles[posX / sizeX][posY / sizeY] = TileMap.createFromImage(image.getSubimage(posX, posY, sizeX, sizeY));
            }
        }
        return (x, y) -> tiles[x][y];
    }

    public Tile getTile(int var1, int var2);
}

