/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.animation;

import de.pirckheimer_gymnasium.engine_pi.animation.Interpolator;
import de.pirckheimer_gymnasium.engine_pi.animation.KeyFrame;
import de.pirckheimer_gymnasium.engine_pi.animation.interpolation.ConstantInterpolator;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;

public class KeyFrames
implements FrameUpdateListener {
    private final Consumer<Double> toAnimate;
    private boolean isLocked = false;
    private double currentAnimationTime;
    private double currentInterpolationEndpoint;
    private KeyFrame<Double> currentKeyframe;
    private Interpolator<Double> currentInterpolator;
    private boolean infinite = true;
    private boolean paused = false;
    private final ArrayList<KeyFrame<Double>> keyFrames = new ArrayList();

    @API
    public KeyFrames(Consumer<Double> toAnimate) {
        this.toAnimate = toAnimate;
    }

    @API
    public void addKeyframe(KeyFrame<Double> keyFrame) {
        if (this.isLocked) {
            throw new RuntimeException("Keyframes k\u00f6nnen nach Beginn der Animation nicht mehr hinzugef\u00fcgt werden.");
        }
        this.keyFrames.add(keyFrame);
        Collections.sort(this.keyFrames);
    }

    @API
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @API
    public boolean isPaused() {
        return this.paused;
    }

    @API
    public void setInifinite(boolean infinite) {
        this.infinite = infinite;
    }

    @API
    public boolean isInfinite() {
        return this.infinite;
    }

    @Override
    public void onFrameUpdate(double deltaSeconds) {
        if (this.paused) {
            return;
        }
        if (!this.isLocked) {
            this.prepForAnimation();
        }
        if (this.currentInterpolationEndpoint == -1.0) {
            if (this.infinite) {
                this.currentInterpolator.interpolate(0.0);
            }
            return;
        }
        if (this.currentAnimationTime < this.currentInterpolationEndpoint) {
            this.toAnimate.accept(this.currentInterpolator.interpolate((this.currentAnimationTime - this.currentKeyframe.getTimecode()) / (this.currentInterpolationEndpoint - this.currentKeyframe.getTimecode())));
        } else {
            this.setupKeyframeForInterpolation(this.currentKeyframe.getNext());
        }
        this.currentAnimationTime += deltaSeconds;
    }

    private void prepForAnimation() {
        if (this.keyFrames.isEmpty()) {
            throw new RuntimeException("Ein leeres Keyframe-Set sollte animiert werden.");
        }
        this.currentAnimationTime = 0.0;
        KeyFrame<Double> first = this.keyFrames.get(0);
        if (first.getTimecode() != 0.0) {
            this.addKeyframe(new KeyFrame<Double>(first.getValue(), KeyFrame.Type.LINEAR, 0.0));
        }
        for (int i = 0; i < this.keyFrames.size() - 1; ++i) {
            this.keyFrames.get(i).setNext(this.keyFrames.get(i + 1));
        }
        this.setupKeyframeForInterpolation(this.keyFrames.get(0));
        this.isLocked = true;
    }

    private void setupKeyframeForInterpolation(KeyFrame<Double> keyFrame) {
        this.currentKeyframe = keyFrame;
        if (keyFrame.hasNext()) {
            this.currentInterpolator = keyFrame.generateInterpolator(keyFrame.getNext().getValue());
            this.currentInterpolationEndpoint = keyFrame.getNext().getTimecode();
        } else {
            this.currentInterpolator = new ConstantInterpolator<Double>(keyFrame.getValue());
            this.currentInterpolationEndpoint = -1.0;
        }
    }
}

