/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.event;

import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.event.EventListeners;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListenerRegistration;

public abstract class AggregateFrameUpdateListener
implements FrameUpdateListener,
FrameUpdateListenerRegistration {
    private final EventListeners<FrameUpdateListener> listeners = new EventListeners();
    private boolean paused = false;

    @API
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @API
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void onFrameUpdate(double deltaSeconds) {
        if (!this.paused) {
            this.listeners.invoke(listener -> listener.onFrameUpdate(deltaSeconds));
        }
    }

    @Override
    public EventListeners<FrameUpdateListener> getFrameUpdateListeners() {
        return this.listeners;
    }
}

