/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.event;

import de.pirckheimer_gymnasium.engine_pi.Camera;
import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.event.DefaultListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseScrollEvent;
import java.awt.event.KeyEvent;

public class DefaultControl
implements DefaultListener {
    private static final double CAMERA_SPEED = 7.0;

    private Camera getCamera() {
        Scene scene = Game.getActiveScene();
        if (scene != null) {
            return scene.getCamera();
        }
        return null;
    }

    private boolean hasNoScene() {
        return Game.getActiveScene() == null;
    }

    @Override
    public void onKeyDown(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 68: {
                if (!Game.isKeyPressed(18)) break;
                Game.toggleDebug();
                break;
            }
            case 27: {
                Game.exit();
            }
        }
    }

    @Override
    public void onFrameUpdate(double delta) {
        if (this.hasNoScene()) {
            return;
        }
        Camera camera = this.getCamera();
        if (camera == null) {
            return;
        }
        if (Game.isKeyPressed(18)) {
            double dX = 0.0;
            double dY = 0.0;
            if (Game.isKeyPressed(38)) {
                dY = 7.0 * delta;
            } else if (Game.isKeyPressed(40)) {
                dY = -7.0 * delta;
            }
            if (Game.isKeyPressed(37)) {
                dX = -7.0 * delta;
            } else if (Game.isKeyPressed(39)) {
                dX = 7.0 * delta;
            }
            if (dX != 0.0 || dY != 0.0) {
                camera.moveBy(dX, dY);
            }
        }
    }

    @Override
    public void onMouseScrollMove(MouseScrollEvent event) {
        if (!Game.isKeyPressed(18)) {
            return;
        }
        if (this.hasNoScene()) {
            return;
        }
        Camera camera = this.getCamera();
        if (camera == null) {
            return;
        }
        double rotation = event.getPreciseWheelRotation();
        double factor = rotation > 0.0 ? 1.0 + 0.3 * rotation : 1.0 / (1.0 - 0.3 * rotation);
        double newZoom = camera.getMeter() * factor;
        if (newZoom <= 0.0) {
            return;
        }
        camera.setMeter(newZoom);
    }
}

