/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.event;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;

public class PressedKeyRepeater
implements KeyStrokeListener {
    private final List<Task> tasks;
    private final List<Executor> executors;
    private double defaultInterval = 0.03;
    private double defaultInitialInterval = 0.15;

    public PressedKeyRepeater(double interval, double initialInterval) {
        if (interval > 0.0) {
            this.defaultInterval = interval;
        }
        if (initialInterval > 0.0) {
            this.defaultInitialInterval = initialInterval;
        }
        this.tasks = new ArrayList<Task>();
        this.executors = new ArrayList<Executor>();
        Game.addKeyStrokeListener(this);
    }

    public PressedKeyRepeater() {
        this(0.0, 0.0);
    }

    public void addTask(int keyCode, Runnable repeatedTask, double interval, double initialInterval) {
        this.tasks.add(new Task(keyCode, repeatedTask, interval, initialInterval));
    }

    public void addTask(int keyCode, Runnable repeatedTask) {
        this.tasks.add(new Task(keyCode, repeatedTask));
    }

    public void addTask(int keyCode, Runnable repeatedTask, Runnable finalTask) {
        this.tasks.add(new Task(keyCode, repeatedTask, finalTask));
    }

    public void addTask(int keyCode, Runnable initialTask, Runnable repeatedTask, Runnable finalTask) {
        this.tasks.add(new Task(keyCode, initialTask, repeatedTask, finalTask));
    }

    public void stop() {
        for (Executor executor : this.executors) {
            executor.stop();
        }
        this.executors.clear();
    }

    @Override
    public void onKeyDown(KeyEvent e) {
        for (Task task : this.tasks) {
            if (e.getKeyCode() != task.getKeyCode()) continue;
            this.executors.add(new Executor(task));
        }
    }

    private class Task {
        private final int keyCode;
        private Runnable initialTask;
        private final Runnable repeatedTask;
        private Runnable finalTask;
        private double initialInterval;
        private double interval;

        public Task(int keyCode, Runnable reatedTask, double interval, double initialInterval) {
            this.keyCode = keyCode;
            this.interval = interval;
            this.repeatedTask = reatedTask;
            this.initialInterval = initialInterval;
        }

        public Task(int keyCode, Runnable runnable) {
            this.keyCode = keyCode;
            this.repeatedTask = runnable;
        }

        public Task(int keyCode, Runnable repeatedTask, Runnable finalTask) {
            this.keyCode = keyCode;
            this.repeatedTask = repeatedTask;
            this.finalTask = finalTask;
        }

        public Task(int keyCode, Runnable initialTask, Runnable repeatedTask, Runnable finalTask) {
            this.keyCode = keyCode;
            this.initialTask = initialTask;
            this.repeatedTask = repeatedTask;
            this.finalTask = finalTask;
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public double getInterval() {
            if (this.interval == 0.0) {
                return PressedKeyRepeater.this.defaultInterval;
            }
            return this.interval;
        }

        public void runInitialTask() {
            if (this.initialTask != null) {
                this.initialTask.run();
            }
        }

        public void runRepeatedTask() {
            this.repeatedTask.run();
        }

        public void runFinalTask() {
            if (this.finalTask != null) {
                this.finalTask.run();
            }
        }

        public double getInitialInterval() {
            if (this.initialInterval == 0.0) {
                return PressedKeyRepeater.this.defaultInitialInterval;
            }
            return this.initialInterval;
        }
    }

    private class Executor
    implements FrameUpdateListener,
    KeyStrokeListener {
        private double countdown;
        private final Task task;

        public Executor(Task task) {
            this.task = task;
            this.countdown = task.getInitialInterval();
            Game.addKeyStrokeListener(this);
            Game.addFrameUpdateListener(this);
            task.runInitialTask();
            task.runRepeatedTask();
        }

        @Override
        public void onFrameUpdate(double deltaSeconds) {
            this.countdown -= deltaSeconds;
            if (this.countdown < 0.0) {
                this.task.runRepeatedTask();
                this.countdown = this.task.getInterval();
            }
        }

        @Override
        public void onKeyDown(KeyEvent e) {
        }

        public void stop() {
            Game.removeFrameUpdateListener(this);
            Game.removeKeyStrokeListener(this);
            this.task.runFinalTask();
        }

        @Override
        public void onKeyUp(KeyEvent e) {
            if (e.getKeyCode() == this.task.getKeyCode()) {
                this.stop();
                PressedKeyRepeater.this.executors.remove(this);
            }
        }
    }
}

