/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.physics;

import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.physics.PhysicsData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.dynamics.Filter;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;

public class FixtureData {
    private double density = 10.0;
    private boolean isDensitySet = false;
    private double friction = 0.0;
    private boolean isFrictionSet = false;
    private double restitution = 0.5;
    private boolean isRestitutionSet = false;
    private Shape shape;
    private boolean isSensor = false;
    private boolean isSensorSet = false;
    private Filter filter = new Filter();

    public double getDensity() {
        return this.density;
    }

    public void setDensity(double density) {
        this.isDensitySet = true;
        this.density = density;
    }

    public double getFriction() {
        return this.friction;
    }

    public void setFriction(double friction) {
        this.isFrictionSet = true;
        this.friction = friction;
    }

    public double getRestitution() {
        return this.restitution;
    }

    public void setRestitution(double restitution) {
        this.isRestitutionSet = true;
        this.restitution = restitution;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public boolean isSensor() {
        return this.isSensor;
    }

    public void setSensor(boolean sensor) {
        this.isSensor = sensor;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        throw new UnsupportedOperationException("Custom Filter sind noch nicht implementiert. Ist f\u00fcr future release geplant.");
    }

    public FixtureData(Shape shape) {
        this.shape = shape;
    }

    @Internal
    FixtureDef createFixtureDef(PhysicsData parent) {
        FixtureDef def = new FixtureDef();
        def.density = (float)(this.isDensitySet ? this.density : parent.getGlobalDensity());
        def.friction = (float)(this.isFrictionSet ? this.friction : parent.getGlobalFriction());
        def.restitution = (float)(this.isRestitutionSet ? this.restitution : parent.getGlobalRestitution());
        def.isSensor = this.isSensorSet ? this.isSensor : parent.getType().isSensor();
        def.filter = this.filter;
        def.shape = this.shape;
        return def;
    }

    @Internal
    public static FixtureData fromFixture(Fixture fixture) {
        FixtureData data = new FixtureData(fixture.m_shape);
        data.setRestitution(fixture.m_restitution);
        data.setDensity(fixture.m_density);
        data.setFriction(fixture.m_density);
        data.setSensor(fixture.m_isSensor);
        data.filter = fixture.m_filter;
        return data;
    }
}

