/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Hexagon;
import de.pirckheimer_gymnasium.engine_pi.actor.Image;
import de.pirckheimer_gymnasium.engine_pi.actor.Pentagon;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.actor.RegularPolygon;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.actor.Triangle;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import java.awt.Color;

public interface ActorCreator {
    public Scene getScene();

    default public Circle createCircle(double diameter, double x, double y) {
        Circle actor = new Circle(diameter);
        actor.setPosition(x, y);
        this.getScene().add(actor);
        return actor;
    }

    default public Circle createCircle(double x, double y) {
        return this.createCircle(1.0, x, y);
    }

    default public Circle createCircle(double x, double y, Color color) {
        Circle actor = this.createCircle(1.0, x, y);
        actor.setColor(color);
        return actor;
    }

    default public Circle createCircle() {
        return this.createCircle(1.0, 0.0, 0.0);
    }

    default public Circle createCircle(double diameter) {
        return this.createCircle(diameter, 0.0, 0.0);
    }

    default public Hexagon createHexagon(double radius) {
        Hexagon actor = new Hexagon(radius);
        this.getScene().add(actor);
        return actor;
    }

    default public Hexagon createHexagon(double radius, double x, double y) {
        Hexagon actor = this.createHexagon(radius);
        actor.setPosition(x, y);
        return actor;
    }

    default public Hexagon createHexagon(double x, double y) {
        return this.createHexagon(0.5, x, y);
    }

    default public Hexagon createHexagon(double x, double y, String color) {
        Hexagon actor = this.createHexagon(x, y);
        actor.setColor(color);
        return actor;
    }

    default public Hexagon createHexagon(double radius, double x, double y, String color) {
        Hexagon actor = this.createHexagon(radius, x, y);
        actor.setColor(color);
        return actor;
    }

    default public Image createImage(String filePath, double pixelPerMeter) {
        Image actor = new Image(filePath, pixelPerMeter);
        this.getScene().add(actor);
        return actor;
    }

    default public Image createImage(String filePath, double width, double height) {
        Image actor = new Image(filePath, width, height);
        this.getScene().add(actor);
        return actor;
    }

    default public Pentagon createPentagon(double radius) {
        Pentagon actor = new Pentagon(radius);
        this.getScene().add(actor);
        return actor;
    }

    default public Pentagon createPentagon(double radius, double x, double y) {
        Pentagon actor = this.createPentagon(radius);
        actor.setPosition(x, y);
        return actor;
    }

    default public Pentagon createPentagon(double x, double y) {
        return this.createPentagon(0.5, x, y);
    }

    default public Rectangle createRectangle(double width, double height, double x, double y) {
        Rectangle actor = new Rectangle(width, height);
        actor.setPosition(x, y);
        this.getScene().add(actor);
        return actor;
    }

    default public Rectangle createRectangle(double width, double height) {
        return this.createRectangle(width, height, 0.0, 0.0);
    }

    default public Rectangle createRectangle(int x, int y) {
        return this.createRectangle(1.0, 1.0, x, y);
    }

    default public Triangle createTriangle(int x, int y) {
        Triangle actor = this.createTriangle(1.0, 1.0);
        actor.setPosition(x, y);
        return actor;
    }

    default public Triangle createTriangle(Vector point1, Vector point2, Vector point3) {
        Triangle actor = new Triangle(point1, point2, point3);
        this.getScene().add(actor);
        return actor;
    }

    @API
    default public Triangle createTriangle(double x1, double y1, double x2, double y2, double x3, double y3) {
        Triangle actor = new Triangle(x1, y1, x2, y2, x3, y3);
        this.getScene().add(actor);
        return actor;
    }

    default public Triangle createTriangle(double width, double height) {
        Triangle actor = new Triangle(width, height);
        this.getScene().add(actor);
        return actor;
    }

    default public RegularPolygon createRegularPolygon(int numSides, double radius) {
        RegularPolygon actor = new RegularPolygon(numSides, radius);
        this.getScene().add(actor);
        return actor;
    }

    default public RegularPolygon createRegularPolygon(int numSides) {
        return this.createRegularPolygon(numSides, 1.0);
    }

    default public RegularPolygon createRegularPolygon(int numSides, double radius, double x, double y) {
        RegularPolygon actor = this.createRegularPolygon(numSides, radius);
        actor.setPosition(x, y);
        return actor;
    }

    default public RegularPolygon createRegularPolygon(int numSides, double x, double y) {
        return this.createRegularPolygon(numSides, 1.0, x, y);
    }

    default public Text createText(String content, double height) {
        Text actor = new Text(content, height);
        this.getScene().add(actor);
        return actor;
    }

    default public Text createText(String content) {
        return this.createText(content, 1.0);
    }

    default public Text createText(String content, double height, double x, double y) {
        Text actor = this.createText(content, height);
        actor.setPosition(x, y);
        return actor;
    }

    default public Text createText(String content, double x, double y) {
        return this.createText(content, 1.0, x, y);
    }
}

