/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.debug;

import de.pirckheimer_gymnasium.engine_pi.Camera;
import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public final class CoordinateSystemDrawer {
    private static final int GRID_SIZE_IN_PIXELS = 150;
    private static final int GRID_SIZE_METER_LIMIT = 100000;
    private static final int DEBUG_TEXT_SIZE = 12;

    @Internal
    public static void draw(Graphics2D g, Scene scene, int width, int height) {
        AffineTransform pre = g.getTransform();
        Camera camera = scene.getCamera();
        Vector position = camera.getPosition();
        double rotation = -camera.getRotation();
        g.setClip(0, 0, width, height);
        g.translate(width / 2, height / 2);
        double pixelPerMeter = camera.getMeter();
        g.rotate(Math.toRadians(rotation), 0.0, 0.0);
        g.translate(-position.getX() * pixelPerMeter, position.getY() * pixelPerMeter);
        int gridSizeInMeters = (int)Math.round(150.0 / pixelPerMeter);
        double gridSizeInPixels = (double)gridSizeInMeters * pixelPerMeter;
        double gridSizeFactor = gridSizeInPixels / (double)gridSizeInMeters;
        if (gridSizeInMeters > 0 && gridSizeInMeters < 100000) {
            int x;
            int windowSizeInPixels = Math.max(width, height);
            int startX = (int)(position.getX() - (double)(windowSizeInPixels / 2) / pixelPerMeter);
            int startY = (int)(-1.0 * position.getY() - (double)(windowSizeInPixels / 2) / pixelPerMeter);
            startX -= startX % gridSizeInMeters + gridSizeInMeters;
            startY -= startY % gridSizeInMeters + gridSizeInMeters;
            int stopX = (int)((double)(startX -= gridSizeInMeters) + (double)windowSizeInPixels / pixelPerMeter + (double)(gridSizeInMeters * 2));
            int stopY = (int)((double)startY + (double)windowSizeInPixels / pixelPerMeter + (double)(gridSizeInMeters * 2));
            g.setFont(new Font("Monospaced", 0, 12));
            g.setColor(Resources.COLORS.get("white", 150));
            for (x = startX; x <= stopX; x += gridSizeInMeters) {
                g.fillRect((int)((double)x * gridSizeFactor) - 1, (int)((double)(startY - 1) * gridSizeFactor), 2, (int)((double)windowSizeInPixels + 3.0 * gridSizeInPixels));
            }
            for (int y = startY; y <= stopY; y += gridSizeInMeters) {
                g.fillRect((int)((double)(startX - 1) * gridSizeFactor), (int)((double)y * gridSizeFactor - 1.0), (int)((double)windowSizeInPixels + 3.0 * gridSizeInPixels), 2);
            }
            for (x = startX; x <= stopX; x += gridSizeInMeters) {
                for (int y = startY; y <= stopY; y += gridSizeInMeters) {
                    g.drawString(x + " / " + -y, (int)((double)x * gridSizeFactor + 5.0), (int)((double)y * gridSizeFactor - 5.0));
                }
            }
        }
        g.setTransform(pre);
    }

    public static void main(String[] args) {
        Game.setDebug(true);
        Game.start();
    }
}

