/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.event;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;

public class PressedKeyRepeater
implements KeyStrokeListener {
    private final List<PressedKeyListener> listeners;
    private final List<PressedKeyExecutor> executors;
    private double DEFAULT_INTERVAL = 0.03;
    private double DEFAULT_INITIAL_INTERVAL = 0.15;

    public PressedKeyRepeater(double interval, double initialInterval) {
        if (interval > 0.0) {
            this.DEFAULT_INTERVAL = interval;
        }
        if (initialInterval > 0.0) {
            this.DEFAULT_INITIAL_INTERVAL = initialInterval;
        }
        this.listeners = new ArrayList<PressedKeyListener>();
        this.executors = new ArrayList<PressedKeyExecutor>();
        Game.addKeyStrokeListener(this);
    }

    public PressedKeyRepeater() {
        this(0.0, 0.0);
    }

    public void addListener(int keyCode, Runnable repeatedTask, double interval, double initialInterval) {
        this.listeners.add(new PressedKeyListener(keyCode, repeatedTask, interval, initialInterval));
    }

    public void addListener(int keyCode, Runnable repeatedTask) {
        this.listeners.add(new PressedKeyListener(keyCode, repeatedTask));
    }

    public void addListener(int keyCode, Runnable repeatedTask, Runnable finalTask) {
        this.listeners.add(new PressedKeyListener(keyCode, repeatedTask, finalTask));
    }

    public void addListener(int keyCode, Runnable initialTask, Runnable repeatedTask, Runnable finalTask) {
        this.listeners.add(new PressedKeyListener(keyCode, initialTask, repeatedTask, finalTask));
    }

    public void stop() {
        for (PressedKeyExecutor executor : this.executors) {
            executor.stop();
        }
        this.executors.clear();
    }

    @Override
    public void onKeyDown(KeyEvent event) {
        for (PressedKeyListener task : this.listeners) {
            if (event.getKeyCode() != task.getKeyCode()) continue;
            this.executors.add(new PressedKeyExecutor(task));
        }
    }

    private class PressedKeyListener {
        private final int keyCode;
        private double interval;
        private double initialInterval;
        private Runnable initialTask;
        private final Runnable repeatedTask;
        private Runnable finalTask;

        public PressedKeyListener(int keyCode, Runnable reatedTask, double interval, double initialInterval) {
            this.keyCode = keyCode;
            this.interval = interval;
            this.repeatedTask = reatedTask;
            this.initialInterval = initialInterval;
        }

        public PressedKeyListener(int keyCode, Runnable repeatedTask) {
            this.keyCode = keyCode;
            this.repeatedTask = repeatedTask;
        }

        public PressedKeyListener(int keyCode, Runnable repeatedTask, Runnable finalTask) {
            this.keyCode = keyCode;
            this.repeatedTask = repeatedTask;
            this.finalTask = finalTask;
        }

        public PressedKeyListener(int keyCode, Runnable initialTask, Runnable repeatedTask, Runnable finalTask) {
            this.keyCode = keyCode;
            this.initialTask = initialTask;
            this.repeatedTask = repeatedTask;
            this.finalTask = finalTask;
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public double getInterval() {
            if (this.interval == 0.0) {
                return PressedKeyRepeater.this.DEFAULT_INTERVAL;
            }
            return this.interval;
        }

        public void runInitialTask() {
            if (this.initialTask != null) {
                this.initialTask.run();
            }
        }

        public void runRepeatedTask() {
            this.repeatedTask.run();
        }

        public void runFinalTask() {
            if (this.finalTask != null) {
                this.finalTask.run();
            }
        }

        public double getInitialInterval() {
            if (this.initialInterval == 0.0) {
                return PressedKeyRepeater.this.DEFAULT_INITIAL_INTERVAL;
            }
            return this.initialInterval;
        }
    }

    private class PressedKeyExecutor
    implements FrameUpdateListener,
    KeyStrokeListener {
        private double countdown;
        private final PressedKeyListener action;

        public PressedKeyExecutor(PressedKeyListener action) {
            this.action = action;
            this.countdown = action.getInitialInterval();
            Game.addKeyStrokeListener(this);
            Game.addFrameUpdateListener(this);
            action.runInitialTask();
            action.runRepeatedTask();
        }

        @Override
        public void onFrameUpdate(double pastTime) {
            this.countdown -= pastTime;
            if (this.countdown < 0.0) {
                this.action.runRepeatedTask();
                this.countdown = this.action.getInterval();
            }
        }

        @Override
        public void onKeyDown(KeyEvent e) {
        }

        public void stop() {
            Game.removeFrameUpdateListener(this);
            Game.removeKeyStrokeListener(this);
            this.action.runFinalTask();
        }

        @Override
        public void onKeyUp(KeyEvent e) {
            if (e.getKeyCode() == this.action.getKeyCode()) {
                this.stop();
                PressedKeyRepeater.this.executors.remove(this);
            }
        }
    }
}

