/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.physics;

import de.pirckheimer_gymnasium.engine_pi.Layer;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Joint;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionEvent;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionListener;
import de.pirckheimer_gymnasium.engine_pi.physics.JointBuilder;
import de.pirckheimer_gymnasium.engine_pi.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jbox2d.callbacks.ContactImpulse;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.Manifold;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactEdge;

public class WorldHandler
implements ContactListener {
    public static final int CATEGORY_PASSIVE = 1;
    public static final int CATEGORY_STATIC = 2;
    public static final int CATEGORY_KINEMATIC = 4;
    public static final int CATEGORY_DYNAMIC = 8;
    public static final int CATEGORY_PARTICLE = 16;
    public static final double STEP_TIME = (double)0.008f;
    private final Layer layer;
    private boolean worldPaused = false;
    private final World world;
    private final Map<Body, List<Checkup<? extends Actor>>> specificCollisionListeners = new ConcurrentHashMap<Body, List<Checkup<? extends Actor>>>();
    private final Map<Body, List<CollisionListener<Actor>>> generalCollisonListeners = new HashMap<Body, List<CollisionListener<Actor>>>();
    private final Collection<FixturePair> contactsToIgnore = new ArrayList<FixturePair>();
    private double simulationAccumulator = 0.0;

    @Internal
    public WorldHandler(Layer layer) {
        this.layer = layer;
        this.world = new World(new Vec2());
        this.world.setContactListener(this);
    }

    @Internal
    public World getWorld() {
        return this.world;
    }

    public void setWorldPaused(boolean worldPaused) {
        this.worldPaused = worldPaused;
    }

    public boolean isWorldPaused() {
        return this.worldPaused;
    }

    @Internal
    public void assertNoWorldStep() {
        if (this.getWorld().isLocked()) {
            throw new RuntimeException("Die Operation kann nicht w\u00e4hrend des World-Step ausgef\u00fchrt werden. Ggf. mit Game.afterWorldStep wrappen.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void step(double pastTime) {
        if (this.worldPaused) {
            return;
        }
        WorldHandler worldHandler = this;
        synchronized (worldHandler) {
            World world = this.world;
            synchronized (world) {
                this.simulationAccumulator += pastTime;
                while (this.simulationAccumulator >= (double)0.008f) {
                    this.simulationAccumulator -= (double)0.008f;
                    this.world.step(0.008f, 6, 3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Body createBody(BodyDef bd, Actor actor) {
        Body body;
        World world = this.world;
        synchronized (world) {
            body = this.world.createBody(bd);
            body.setUserData(actor);
        }
        return body;
    }

    @Internal
    public void removeAllInternalReferences(Body body) {
        this.specificCollisionListeners.remove(body);
        this.generalCollisonListeners.remove(body);
    }

    @Internal
    public void addContactToBlacklist(Contact contact) {
        this.contactsToIgnore.add(new FixturePair(contact.m_fixtureA, contact.m_fixtureB));
    }

    @Override
    public void beginContact(Contact contact) {
        this.processContact(contact, true);
    }

    @Override
    public void endContact(Contact contact) {
        this.processContact(contact, false);
    }

    @Internal
    private void processContact(Contact contact, boolean isBegin) {
        Body b2;
        Body b1 = contact.getFixtureA().getBody();
        if (b1 == (b2 = contact.getFixtureB().getBody())) {
            Logger.error("Collision", "Inter-Body Collision!");
            return;
        }
        if (b1.hashCode() == b2.hashCode()) {
            List<Checkup<? extends Actor>> result2;
            List<Checkup<? extends Actor>> result1 = this.specificCollisionListeners.get(b1);
            if (result1 != null) {
                for (Checkup<? extends Actor> checkup : result1) {
                    checkup.checkCollision(b2, contact, isBegin);
                }
            }
            if ((result2 = this.specificCollisionListeners.get(b2)) != null) {
                for (Checkup<? extends Actor> checkup : result2) {
                    checkup.checkCollision(b1, contact, isBegin);
                }
            }
        } else {
            Body higher;
            Body lower;
            if (b1.hashCode() < b2.hashCode()) {
                lower = b1;
                higher = b2;
            } else {
                lower = b2;
                higher = b1;
            }
            List<Checkup<? extends Actor>> result = this.specificCollisionListeners.get(lower);
            if (result != null) {
                for (Checkup<? extends Actor> checkup : result) {
                    checkup.checkCollision(higher, contact, isBegin);
                }
            }
        }
        this.generalCheckup(b1, b2, contact, isBegin);
        this.generalCheckup(b2, b1, contact, isBegin);
        if (!isBegin) {
            contact.setEnabled(true);
            this.removeFromBlacklist(contact);
        }
    }

    private void removeFromBlacklist(Contact contact) {
        FixturePair fixturePair = null;
        for (FixturePair ignoredPair : this.contactsToIgnore) {
            if (!ignoredPair.matches(contact.m_fixtureA, contact.m_fixtureB)) continue;
            fixturePair = ignoredPair;
            break;
        }
        if (fixturePair != null) {
            this.contactsToIgnore.remove(fixturePair);
        }
    }

    @Internal
    private void generalCheckup(Body act, Body col, Contact contact, boolean isBegin) {
        List<CollisionListener<Actor>> list = this.generalCollisonListeners.get(act);
        if (list != null) {
            Actor other = (Actor)col.getUserData();
            if (other == null) {
                return;
            }
            CollisionEvent<Actor> collisionEvent = new CollisionEvent<Actor>(contact, other);
            for (CollisionListener<Actor> listener : list) {
                if (isBegin) {
                    listener.onCollision(collisionEvent);
                    continue;
                }
                listener.onCollisionEnd(collisionEvent);
            }
        }
    }

    @Override
    public void preSolve(Contact contact, Manifold manifold) {
        for (FixturePair ignoredPair : this.contactsToIgnore) {
            if (!ignoredPair.matches(contact.m_fixtureA, contact.m_fixtureB)) continue;
            contact.setEnabled(false);
        }
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse contactImpulse) {
    }

    public Layer getLayer() {
        return this.layer;
    }

    @Internal
    public Fixture[] queryAABB(AABB aabb) {
        ArrayList fixtures = new ArrayList();
        this.world.queryAABB(fixtures::add, aabb);
        return fixtures.toArray(new Fixture[0]);
    }

    @Internal
    public static boolean isBodyCollision(Body a, Body b) {
        if (a == null || b == null) {
            return false;
        }
        ContactEdge contact = a.getContactList();
        while (contact != null) {
            if (contact.other == b && contact.contact.isTouching()) {
                return true;
            }
            contact = contact.next;
        }
        return false;
    }

    @Internal
    public static void addGenericCollisionListener(CollisionListener<Actor> listener, Actor actor) {
        actor.addMountListener(() -> {
            Body body = actor.getPhysicsHandler().getBody();
            if (body == null) {
                throw new IllegalStateException("Body is missing on an Actor with an existing WorldHandler");
            }
            actor.getPhysicsHandler().getWorldHandler().generalCollisonListeners.computeIfAbsent(body, key -> new CopyOnWriteArrayList()).add(listener);
        });
    }

    @Internal
    public static <E extends Actor> void addSpecificCollisionListener(Actor actor, E collider, CollisionListener<E> listener) {
        WorldHandler.addMountListener(actor, collider, worldHandler -> {
            Body higher;
            Body lower;
            Body b1 = actor.getPhysicsHandler().getBody();
            Body b2 = collider.getPhysicsHandler().getBody();
            if (b1 == null || b2 == null) {
                Logger.error("Kollision", "Ein {@link Actor}-Objekt ohne physikalischen Body wurde zur Kollisions\u00fcberwachung angemeldet.");
                return;
            }
            if (b1.hashCode() < b2.hashCode()) {
                lower = b1;
                higher = b2;
            } else {
                lower = b2;
                higher = b1;
            }
            Checkup<Actor> checkup = new Checkup<Actor>(listener, higher, collider);
            worldHandler.specificCollisionListeners.computeIfAbsent(lower, key -> new CopyOnWriteArrayList()).add(checkup);
        });
    }

    @Internal
    public static <JointType extends org.jbox2d.dynamics.joints.Joint, Wrapper extends Joint<JointType>> Wrapper createJoint(Actor a, Actor b, JointBuilder<JointType> jointBuilder, Wrapper wrapper) {
        List<Runnable> releaseCallbacks = WorldHandler.addMountListener(a, b, worldHandler -> wrapper.setJoint(jointBuilder.createJoint(worldHandler.getWorld(), a.getPhysicsHandler().getBody(), b.getPhysicsHandler().getBody()), (WorldHandler)worldHandler));
        releaseCallbacks.forEach(wrapper::addReleaseListener);
        return wrapper;
    }

    @Internal
    public static List<Runnable> addMountListener(Actor a, Actor b, Consumer<WorldHandler> runnable) {
        ArrayList<Runnable> releases = new ArrayList<Runnable>();
        AtomicBoolean skipListener = new AtomicBoolean(true);
        Runnable listenerA = () -> {
            WorldHandler worldHandler = a.getPhysicsHandler().getWorldHandler();
            if (!skipListener.get() && b.isMounted() && b.getPhysicsHandler().getWorldHandler() == worldHandler) {
                runnable.accept(worldHandler);
            }
        };
        Runnable listenerB = () -> {
            WorldHandler worldHandler = b.getPhysicsHandler().getWorldHandler();
            if (!skipListener.get() && a.isMounted() && a.getPhysicsHandler().getWorldHandler() == worldHandler) {
                runnable.accept(worldHandler);
            }
        };
        a.addMountListener(listenerA);
        b.addMountListener(listenerB);
        skipListener.set(false);
        releases.add(() -> a.removeMountListener(listenerA));
        releases.add(() -> b.removeMountListener(listenerB));
        if (a.isMounted() && b.isMounted()) {
            runnable.accept(a.getPhysicsHandler().getWorldHandler());
        }
        return releases;
    }

    private static class FixturePair {
        private final Fixture f1;
        private final Fixture f2;

        public FixturePair(Fixture b1, Fixture b2) {
            this.f1 = b1;
            this.f2 = b2;
        }

        public boolean matches(Fixture a, Fixture b) {
            return this.f1 == a && this.f2 == b || this.f1 == b && this.f2 == a;
        }
    }

    private static class Checkup<E extends Actor> {
        private final CollisionListener<E> listener;
        private final Body body;
        private final E collidingActor;

        private Checkup(CollisionListener<E> listener, Body body, E collidingActor) {
            this.listener = listener;
            this.body = body;
            this.collidingActor = collidingActor;
        }

        public void checkCollision(Body body, Contact contact, boolean isBegin) {
            if (this.body == body) {
                CollisionEvent<E> collisionEvent = new CollisionEvent<E>(contact, this.collidingActor);
                if (isBegin) {
                    this.listener.onCollision(collisionEvent);
                } else {
                    this.listener.onCollisionEnd(collisionEvent);
                }
            }
        }
    }
}

