/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.debug.CoordinateSystemDrawer;
import de.pirckheimer_gymnasium.engine_pi.debug.InfoBoxDrawer;
import de.pirckheimer_gymnasium.engine_pi.event.EventListeners;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.graphics.RenderTarget;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class GameLoop {
    private static final double DESIRED_FRAME_DURATION = 0.016;
    private static final int NANOSECONDS_PER_SECOND = 1000000000;
    private final ExecutorService threadPoolExecutor = Executors.newCachedThreadPool();
    private final RenderTarget render;
    private final Supplier<Scene> currentScene;
    private final Supplier<Boolean> isDebug;
    private final Queue<Runnable> dispatchableQueue = new ConcurrentLinkedQueue<Runnable>();
    private final EventListeners<FrameUpdateListener> frameUpdateListeners = new EventListeners();
    private double frameDuration;

    public GameLoop(RenderTarget render, Supplier<Scene> currentScene, Supplier<Boolean> isDebug) {
        this.render = render;
        this.currentScene = currentScene;
        this.isDebug = isDebug;
    }

    public void enqueue(Runnable runnable) {
        this.dispatchableQueue.add(runnable);
    }

    public void run() {
        this.frameDuration = 0.016;
        long frameStart = System.nanoTime();
        while (!Thread.currentThread().isInterrupted()) {
            Scene scene = this.currentScene.get();
            try {
                double pastTime = Math.min(0.032, this.frameDuration);
                scene.step(pastTime, this.threadPoolExecutor::submit);
                this.frameUpdateListeners.invoke(listener -> listener.onFrameUpdate(pastTime));
                scene.getCamera().onFrameUpdate();
                scene.invokeFrameUpdateListeners(pastTime);
                Runnable runnable = this.dispatchableQueue.poll();
                while (runnable != null) {
                    runnable.run();
                    runnable = this.dispatchableQueue.poll();
                }
                this.render();
                long frameEnd = System.nanoTime();
                double duration = (double)(frameEnd - frameStart) / 1.0E9;
                if (duration < 0.016) {
                    try {
                        Thread.sleep((int)(1000.0 * (0.016 - duration)));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                frameEnd = System.nanoTime();
                this.frameDuration = (double)(frameEnd - frameStart) / 1.0E9;
                frameStart = frameEnd;
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.threadPoolExecutor.shutdown();
        try {
            this.threadPoolExecutor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public EventListeners<FrameUpdateListener> getFrameUpdateListener() {
        return this.frameUpdateListeners;
    }

    public void render(RenderTarget renderTarget) {
        renderTarget.render(this::render);
    }

    private void render() {
        this.render.render(this::render);
    }

    @Internal
    private void render(Graphics2D g, int width, int height) {
        Scene scene = this.currentScene.get();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g.setColor(scene.getBackgroundColor());
        g.fillRect(0, 0, width, height);
        g.setClip(0, 0, width, height);
        AffineTransform transform = g.getTransform();
        scene.render(g, width, height);
        g.setTransform(transform);
        if (this.isDebug.get().booleanValue()) {
            CoordinateSystemDrawer.draw(g, scene, width, height);
            InfoBoxDrawer.draw(g, scene, this.frameDuration, scene.getWorldHandler().getWorld().getBodyCount());
        }
        g.dispose();
    }

    public static void main(String[] args) {
        Game.setDebug(true);
        Game.start();
    }
}

