/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.actor.Joint;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;

public final class PrismaticJoint
extends Joint<org.jbox2d.dynamics.joints.PrismaticJoint> {
    private double lowerLimit;
    private double upperLimit;
    private boolean motorEnabled;
    private boolean limitEnabled;
    private double motorSpeed;
    private double maximumMotorForce;

    @API
    public void setMaximumMotorForce(double maximumMotorForce) {
        this.maximumMotorForce = maximumMotorForce;
        this.motorEnabled = true;
        org.jbox2d.dynamics.joints.PrismaticJoint joint = (org.jbox2d.dynamics.joints.PrismaticJoint)this.getJoint();
        if (joint != null) {
            joint.setMaxMotorForce((float)maximumMotorForce);
            joint.enableMotor(true);
        }
    }

    @API
    public double getMaximumMotorForce() {
        return this.maximumMotorForce;
    }

    @API
    public double getLowerLimit() {
        return this.lowerLimit;
    }

    @API
    public void setLowerLimit(double lowerLimit) {
        this.lowerLimit = lowerLimit;
        this.limitEnabled = true;
        org.jbox2d.dynamics.joints.PrismaticJoint joint = (org.jbox2d.dynamics.joints.PrismaticJoint)this.getJoint();
        if (joint != null) {
            joint.setLimits((float)lowerLimit, (float)this.upperLimit);
            joint.enableLimit(true);
        }
    }

    @API
    public double getUpperLimit() {
        return this.upperLimit;
    }

    @API
    public void setUpperLimit(double upperLimit) {
        this.upperLimit = upperLimit;
        this.limitEnabled = true;
        org.jbox2d.dynamics.joints.PrismaticJoint joint = (org.jbox2d.dynamics.joints.PrismaticJoint)this.getJoint();
        if (joint != null) {
            joint.setLimits((float)this.lowerLimit, (float)upperLimit);
            joint.enableLimit(true);
        }
    }

    @API
    public double getMotorSpeed() {
        org.jbox2d.dynamics.joints.PrismaticJoint joint = (org.jbox2d.dynamics.joints.PrismaticJoint)this.getJoint();
        if (joint != null) {
            return joint.getMotorSpeed();
        }
        return this.motorSpeed;
    }

    @API
    public void setMotorSpeed(double motorSpeed) {
        this.motorSpeed = motorSpeed;
        this.motorEnabled = true;
        org.jbox2d.dynamics.joints.PrismaticJoint joint = (org.jbox2d.dynamics.joints.PrismaticJoint)this.getJoint();
        if (joint != null) {
            joint.setMotorSpeed((float)motorSpeed);
            joint.enableMotor(true);
        }
    }

    @API
    public boolean isMotorEnabled() {
        return this.motorEnabled;
    }

    @API
    public void setMotorEnabled(boolean motorEnabled) {
        this.motorEnabled = motorEnabled;
        org.jbox2d.dynamics.joints.PrismaticJoint joint = (org.jbox2d.dynamics.joints.PrismaticJoint)this.getJoint();
        if (joint != null) {
            joint.enableMotor(motorEnabled);
        }
    }

    @API
    public boolean isLimitEnabled() {
        return this.limitEnabled;
    }

    @API
    public void setLimitEnabled(boolean limitEnabled) {
        this.limitEnabled = limitEnabled;
        org.jbox2d.dynamics.joints.PrismaticJoint joint = (org.jbox2d.dynamics.joints.PrismaticJoint)this.getJoint();
        if (joint != null) {
            joint.enableLimit(limitEnabled);
        }
    }

    @API
    public void setLimits(double lower, double upper) {
        this.setLowerLimit(lower);
        this.setUpperLimit(upper);
    }

    @API
    public double getTranslation() {
        org.jbox2d.dynamics.joints.PrismaticJoint joint = (org.jbox2d.dynamics.joints.PrismaticJoint)this.getJoint();
        if (joint == null) {
            return 0.0;
        }
        return joint.getJointTranslation();
    }

    @Override
    protected void updateCustomProperties(org.jbox2d.dynamics.joints.PrismaticJoint joint) {
        joint.setMotorSpeed((float)this.motorSpeed);
        joint.setMaxMotorForce((float)this.maximumMotorForce);
        joint.setLimits((float)this.lowerLimit, (float)this.upperLimit);
        joint.enableMotor(this.motorEnabled);
        joint.enableLimit(this.limitEnabled);
    }
}

