/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.animation;

import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.animation.AnimationMode;
import de.pirckheimer_gymnasium.engine_pi.animation.ValueAnimator;
import de.pirckheimer_gymnasium.engine_pi.animation.interpolation.CosinusDouble;
import de.pirckheimer_gymnasium.engine_pi.animation.interpolation.LinearDouble;
import de.pirckheimer_gymnasium.engine_pi.animation.interpolation.SinusDouble;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.event.AggregateFrameUpdateListener;

public class CircleAnimation
extends AggregateFrameUpdateListener {
    @API
    public CircleAnimation(Actor actor, Vector rotationCenter, double durationInSeconds, boolean circleClockwise, boolean rotateActor) {
        Vector currentActorCenter = actor.getCenter();
        double radius = new Vector(rotationCenter, currentActorCenter).getLength();
        Vector rightPoint = rotationCenter.add(new Vector(radius, 0.0));
        ValueAnimator<Double> aX = new ValueAnimator<Double>(durationInSeconds, x -> actor.setCenter((double)x, actor.getCenter().getY()), new CosinusDouble(rightPoint.getX(), radius), AnimationMode.REPEATED, this);
        ValueAnimator<Double> aY = new ValueAnimator<Double>(durationInSeconds, y -> actor.setCenter(actor.getCenter().getX(), (double)y), new SinusDouble(rotationCenter.getY(), circleClockwise ? -radius : radius), AnimationMode.REPEATED, this);
        double angle = rotationCenter.negate().add(rightPoint).getAngle(rotationCenter.negate().add(currentActorCenter));
        if (circleClockwise && currentActorCenter.getY() > rotationCenter.getY() || !circleClockwise && currentActorCenter.getY() < rotationCenter.getY()) {
            angle = 360.0 - angle;
        }
        double actualProgress = angle / 360.0;
        aX.setProgress(actualProgress);
        aY.setProgress(actualProgress);
        this.addFrameUpdateListener(aX);
        this.addFrameUpdateListener(aY);
        if (rotateActor) {
            double rotationAngle = circleClockwise ? angle : -angle;
            ValueAnimator<Double> aR = new ValueAnimator<Double>(durationInSeconds, actor::setRotation, new LinearDouble(-rotationAngle, -rotationAngle + (double)(360 * (circleClockwise ? -1 : 1))), AnimationMode.REPEATED, actor);
            aR.setProgress(actualProgress);
            this.addFrameUpdateListener(aR);
        }
    }
}

