/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.event;

import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.event.EventListeners;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.PeriodicTask;
import de.pirckheimer_gymnasium.engine_pi.event.PeriodicTaskExecutor;
import de.pirckheimer_gymnasium.engine_pi.event.SingleTask;

@API
public interface FrameUpdateListenerRegistration {
    public EventListeners<FrameUpdateListener> getFrameUpdateListeners();

    @API
    default public void addFrameUpdateListener(FrameUpdateListener listener) {
        this.getFrameUpdateListeners().add(listener);
    }

    @API
    default public void removeFrameUpdateListener(FrameUpdateListener listener) {
        this.getFrameUpdateListeners().remove(listener);
    }

    @API
    default public void defer(final Runnable runnable) {
        FrameUpdateListener frameUpdateListener = new FrameUpdateListener(){

            @Override
            public void onFrameUpdate(double time) {
                FrameUpdateListenerRegistration.this.removeFrameUpdateListener(this);
                runnable.run();
            }
        };
        this.addFrameUpdateListener(frameUpdateListener);
    }

    @API
    default public FrameUpdateListener delay(double delay, Runnable task) {
        SingleTask singleTask = new SingleTask(delay, task, this);
        this.addFrameUpdateListener(singleTask);
        return singleTask;
    }

    @API
    default public PeriodicTaskExecutor repeat(double interval, int repetitions, PeriodicTask task, PeriodicTask finalTask) {
        PeriodicTaskExecutor periodicTask = new PeriodicTaskExecutor(interval, repetitions, task, finalTask, this);
        this.addFrameUpdateListener(periodicTask);
        return periodicTask;
    }

    @API
    default public PeriodicTaskExecutor repeat(double interval, PeriodicTask task) {
        return this.repeat(interval, -1, task, null);
    }
}

