/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi;

import de.pirckheimer_gymnasium.engine_pi.Camera;
import de.pirckheimer_gymnasium.engine_pi.GameLoop;
import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.event.DefaultControl;
import de.pirckheimer_gymnasium.engine_pi.event.DefaultListener;
import de.pirckheimer_gymnasium.engine_pi.event.EventListeners;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseButton;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseScrollEvent;
import de.pirckheimer_gymnasium.engine_pi.event.MouseScrollListener;
import de.pirckheimer_gymnasium.engine_pi.event.SceneLaunchListener;
import de.pirckheimer_gymnasium.engine_pi.graphics.RenderPanel;
import de.pirckheimer_gymnasium.engine_pi.sound.Jukebox;
import de.pirckheimer_gymnasium.engine_pi.util.FileUtil;
import de.pirckheimer_gymnasium.engine_pi.util.ImageUtil;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JOptionPane;

public final class Game {
    private static final Jukebox jukebox;
    private static boolean debug;
    private static boolean renderActors;
    private static boolean verbose;
    private static int width;
    private static int height;
    private static final Frame frame;
    private static RenderPanel renderPanel;
    private static Scene scene;
    private static GameLoop loop;
    private static Thread mainThread;
    private static final Collection<Integer> pressedKeys;
    private static DefaultListener defaultControl;
    private static Point mousePosition;
    private static final EventListeners<KeyStrokeListener> keyStrokeListeners;
    private static final EventListeners<MouseClickListener> mouseClickListeners;
    private static final EventListeners<MouseScrollListener> mouseScrollListeners;
    private static final EventListeners<SceneLaunchListener> sceneLaunchListeners;

    @API
    public static void setTitle(String title) {
        frame.setTitle(title);
    }

    @API
    public static Scene start(int width, int height, Scene scene) {
        if (renderPanel != null) {
            throw new IllegalStateException("Game.start wurde bereits ausgef\u00fchrt und kann nur einmal ausgef\u00fchrt werden");
        }
        Game.width = width;
        Game.height = height;
        Game.scene = scene;
        renderPanel = new RenderPanel(width, height);
        frame.setResizable(false);
        frame.add(renderPanel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        renderPanel.allocateBuffers();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Game.exit();
            }
        });
        KeyListener keyListener = new KeyListener();
        frame.addKeyListener(keyListener);
        renderPanel.addKeyListener(keyListener);
        renderPanel.setFocusable(true);
        MouseListener mouseListener = new MouseListener();
        renderPanel.addMouseMotionListener(mouseListener);
        renderPanel.addMouseListener(mouseListener);
        renderPanel.addMouseWheelListener(Game::enqueueMouseScrollEvent);
        try {
            frame.setIconImage((Image)Resources.IMAGES.get("logo/logo.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        mousePosition = new Point(width / 2, height / 2);
        mainThread = new Thread(Game::run, "de.pirckheimer_gymnasium.engine_pi.main");
        mainThread.start();
        mainThread.setPriority(10);
        if (defaultControl != null) {
            Game.setDefaultControl(defaultControl);
        }
        return scene;
    }

    @API
    public static Scene start(Scene scene) {
        return Game.start(800, 600, scene);
    }

    @API
    public static Scene start() {
        return Game.start(new Scene());
    }

    @API
    public static void transitionToScene(Scene scene) {
        Scene previous = Game.getActiveScene();
        if (scene == previous) {
            return;
        }
        Scene next = Objects.requireNonNullElseGet(scene, Scene::new);
        loop.enqueue(() -> {
            sceneLaunchListeners.invoke(listener -> listener.onSceneLaunch(next, previous));
            scene = next;
        });
    }

    private static void run() {
        loop = new GameLoop(renderPanel, Game::getActiveScene, Game::isDebug);
        sceneLaunchListeners.invoke(listener -> listener.onSceneLaunch(Game.getActiveScene(), null));
        loop.run();
        frame.setVisible(false);
        frame.dispose();
        System.exit(0);
    }

    public static DefaultListener getDefaultControl() {
        return defaultControl;
    }

    public static void setDefaultControl(DefaultListener control) {
        defaultControl = control;
        if (control != null) {
            Game.addFrameUpdateListener(defaultControl);
            Game.addKeyStrokeListener(defaultControl);
            Game.addMouseClickListener(defaultControl);
            Game.addMouseScrollListener(defaultControl);
        }
    }

    public static void removeDefaultControl() {
        if (defaultControl != null) {
            Game.removeFrameUpdateListener(defaultControl);
            Game.removeKeyStrokeListener(defaultControl);
            Game.removeMouseClickListener(defaultControl);
            Game.removeMouseScrollListener(defaultControl);
            defaultControl = null;
        }
    }

    private static void enqueueMouseScrollEvent(MouseWheelEvent event) {
        MouseScrollEvent mouseScrollEvent = new MouseScrollEvent(event.getPreciseWheelRotation());
        loop.enqueue(() -> {
            mouseScrollListeners.invoke(listener -> listener.onMouseScrollMove(mouseScrollEvent));
            scene.invokeMouseScrollListeners(mouseScrollEvent);
        });
    }

    public static FrameUpdateListener addFrameUpdateListener(FrameUpdateListener listener) {
        if (loop != null) {
            loop.getFrameUpdateListener().add(listener);
        } else {
            Game.addSceneLaunchListener((next, previous) -> {
                if (previous == null) {
                    loop.getFrameUpdateListener().add(listener);
                }
            });
        }
        return listener;
    }

    public static void removeFrameUpdateListener(FrameUpdateListener listener) {
        loop.getFrameUpdateListener().remove(listener);
    }

    public static void addKeyStrokeListener(KeyStrokeListener listener) {
        keyStrokeListeners.add(listener);
    }

    public static void removeKeyStrokeListener(KeyStrokeListener listener) {
        keyStrokeListeners.remove(listener);
    }

    public static void addMouseClickListener(MouseClickListener listener) {
        mouseClickListeners.add(listener);
    }

    public static void removeMouseClickListener(MouseClickListener listener) {
        mouseClickListeners.remove(listener);
    }

    public static void addMouseScrollListener(MouseScrollListener listener) {
        mouseScrollListeners.add(listener);
    }

    public static void removeMouseScrollListener(MouseScrollListener listener) {
        mouseScrollListeners.remove(listener);
    }

    public static void addSceneLaunchListener(SceneLaunchListener listener) {
        sceneLaunchListeners.add(listener);
    }

    public static void removeSceneLaunchListener(SceneLaunchListener listener) {
        sceneLaunchListeners.remove(listener);
    }

    @API
    public static Scene getActiveScene() {
        return scene;
    }

    @API
    public static boolean isKeyPressed(int keyCode) {
        return pressedKeys.contains(keyCode);
    }

    @API
    public static boolean isRunning() {
        return frame.isVisible();
    }

    @API
    public static void setWindowSize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new RuntimeException("Die Fenstergr\u00f6\u00dfe kann nicht kleiner/gleich 0 sein. Eingabe war: " + width + " - " + height + ".");
        }
        if (renderPanel == null) {
            throw new RuntimeException("Fenster-Resizing ist erst m\u00f6glich, nachdem Game.start ausgef\u00fchrt wurde.");
        }
        int diffX = (width - Game.width) / 2;
        int diffY = (height - Game.height) / 2;
        Game.width = width;
        Game.height = height;
        renderPanel.setSize(width, height);
        renderPanel.setPreferredSize(new Dimension(width, height));
        frame.pack();
        frame.setLocation(Game.frame.getLocation().x - diffX, Game.frame.getLocation().y - diffY);
    }

    @API
    public static Vector getWindowSize() {
        return new Vector(width, height);
    }

    @API
    public static void setWindowPosition(int x, int y) {
        frame.setLocation(x, y);
    }

    @API
    public static void exit() {
        System.exit(0);
    }

    @API
    public static void showMessage(String message, String title) {
        JOptionPane.showMessageDialog(frame, message, title, 1);
    }

    @API
    public static String requestStringInput(String message, String title) {
        return JOptionPane.showInputDialog(frame, message, title, -1);
    }

    @API
    public static boolean requestYesNo(String message, String title) {
        return JOptionPane.showConfirmDialog(frame, message, title, 0, -1) == 0;
    }

    @API
    public static boolean requestOkCancel(String message, String title) {
        return JOptionPane.showConfirmDialog(frame, message, title, 2, -1) == 0;
    }

    @Internal
    public static Vector convertMousePosition(Scene scene, Point mousePosition) {
        Camera camera = scene.getCamera();
        double zoom = camera.getMeter();
        double rotation = camera.getRotation();
        Vector position = camera.getPosition();
        return new Vector(position.getX() + (Math.cos(Math.toRadians(rotation)) * ((double)mousePosition.x - (double)width / 2.0) + Math.sin(Math.toRadians(rotation)) * ((double)mousePosition.y - (double)height / 2.0)) / zoom, position.getY() + (Math.sin(Math.toRadians(rotation)) * ((double)mousePosition.x - (double)width / 2.0) - Math.cos(Math.toRadians(rotation)) * ((double)mousePosition.y - (double)height / 2.0)) / zoom);
    }

    @Internal
    public static Point getMousePositionInFrame() {
        return mousePosition;
    }

    @API
    public static Vector getMousePosition() {
        return scene.getMousePosition();
    }

    @API
    public static void setDebug(boolean value) {
        debug = value;
    }

    @API
    public static boolean isDebug() {
        return debug;
    }

    public static void toggleDebug() {
        Game.setDebug(!Game.isDebug());
    }

    @API
    public static void setRenderActors(boolean value) {
        renderActors = value;
    }

    @API
    public static boolean getRenderActors() {
        return renderActors;
    }

    public static void toggleRenderActors() {
        Game.setRenderActors(!Game.getRenderActors());
    }

    @API
    public static boolean isVerbose() {
        return verbose;
    }

    @API
    public static void setVerbose(boolean value) {
        verbose = value;
    }

    public static Jukebox getJukebox() {
        return jukebox;
    }

    @API
    public static void takeScreenshot() {
        BufferedImage screenshot = new BufferedImage(width, height, 1);
        Graphics2D g = (Graphics2D)screenshot.getGraphics();
        loop.render(source -> source.render(g, width, height));
        String dir = FileUtil.getHome() + "/engine-pi";
        FileUtil.createDir(dir);
        ImageUtil.write(screenshot, dir + "/screenshot_" + System.nanoTime() + ".png");
    }

    static {
        System.setProperty("sun.java2d.opengl", "true");
        System.setProperty("sun.java2d.d3d", "true");
        System.setProperty("sun.java2d.noddraw", "false");
        System.setProperty("sun.java2d.pmoffscreen", "true");
        System.setProperty("sun.java2d.ddoffscreen", "true");
        System.setProperty("sun.java2d.ddscale", "true");
        jukebox = new Jukebox();
        renderActors = true;
        frame = new Frame("Engine Pi");
        scene = new Scene();
        pressedKeys = ConcurrentHashMap.newKeySet();
        defaultControl = new DefaultControl();
        keyStrokeListeners = new EventListeners();
        mouseClickListeners = new EventListeners();
        mouseScrollListeners = new EventListeners();
        sceneLaunchListeners = new EventListeners();
    }

    private static class KeyListener
    extends KeyAdapter {
        private KeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            this.enqueueKeyEvent(event, true);
        }

        @Override
        public void keyReleased(KeyEvent event) {
            this.enqueueKeyEvent(event, false);
        }

        private void enqueueKeyEvent(KeyEvent event, boolean down) {
            boolean pressed = pressedKeys.contains(event.getKeyCode());
            if (down) {
                if (pressed) {
                    return;
                }
                pressedKeys.add(event.getKeyCode());
            } else {
                pressedKeys.remove(event.getKeyCode());
            }
            loop.enqueue(() -> {
                if (down) {
                    keyStrokeListeners.invoke(keyListener -> keyListener.onKeyDown(event));
                    scene.invokeKeyDownListeners(event);
                } else {
                    keyStrokeListeners.invoke(keyListener -> keyListener.onKeyUp(event));
                    scene.invokeKeyUpListeners(event);
                }
            });
        }
    }

    private static class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.enqueueMouseEvent(event, true);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.enqueueMouseEvent(event, false);
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            mousePosition = event.getPoint();
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            mousePosition = event.getPoint();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            mousePosition = event.getPoint();
        }

        private void enqueueMouseEvent(MouseEvent event, boolean down) {
            MouseButton button;
            Vector position = Game.convertMousePosition(scene, event.getPoint());
            switch (event.getButton()) {
                case 1: {
                    button = MouseButton.LEFT;
                    break;
                }
                case 3: {
                    button = MouseButton.RIGHT;
                    break;
                }
                default: {
                    return;
                }
            }
            loop.enqueue(() -> {
                if (down) {
                    mouseClickListeners.invoke(listener -> listener.onMouseDown(position, button));
                    scene.invokeMouseDownListeners(position, button);
                } else {
                    mouseClickListeners.invoke(listener -> listener.onMouseDown(position, button));
                    scene.invokeMouseUpListeners(position, button);
                }
            });
        }
    }
}

