/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.animation.AnimationMode;
import de.pirckheimer_gymnasium.engine_pi.animation.ValueAnimator;
import de.pirckheimer_gymnasium.engine_pi.animation.interpolation.LinearDouble;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureData;
import de.pirckheimer_gymnasium.engine_pi.util.ColorUtil;
import java.awt.Color;
import java.util.function.Supplier;

@API
public abstract class Geometry
extends Actor {
    @API
    public Geometry(Supplier<FixtureData> fixtureSupplier) {
        super(fixtureSupplier);
        this.color = Resources.COLORS.get("green");
    }

    @Override
    @API
    public Color getColor() {
        return this.color;
    }

    @API
    public ValueAnimator<Double> animateColor(double duration, Color color) {
        Color originalColor = this.getColor();
        ValueAnimator<Double> animator = new ValueAnimator<Double>(duration, progress -> this.setColor(ColorUtil.interpolate(originalColor, color, progress)), new LinearDouble(0.0, 1.0), AnimationMode.SINGLE, this);
        this.addFrameUpdateListener(animator);
        return animator;
    }
}

