/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.util;

import de.pirckheimer_gymnasium.engine_pi.Game;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public final class Logger {
    private static BufferedWriter writer;

    private Logger() {
    }

    public static void warning(String s, String tag) {
        StackTraceElement e = Thread.currentThread().getStackTrace()[2];
        Logger.write("WARNUNG", tag, e.getFileName(), e.getLineNumber(), s);
    }

    private static String write(String type, String tag, String filename, int line, String message) {
        return Logger.write(type, tag, filename, line, message, false, true);
    }

    private static String write(String type, String tag, String filename, int line, String message, boolean error, boolean printOnConsole) {
        String str = String.format("[%s][%s][%s] %s (%s:%s)", Logger.getTime(), type, tag, message, filename, line);
        if (printOnConsole) {
            if (error) {
                System.err.println(str);
            } else {
                System.out.println(str);
            }
        }
        return Logger.write(str);
    }

    private static String getTime() {
        return new Date().toString();
    }

    private static String write(String text) {
        try {
            writer.write(text);
            writer.newLine();
            return text;
        }
        catch (IOException e) {
            System.err.println("Logger konnte folgende Zeile nicht schreiben:\n" + text);
            return null;
        }
    }

    public static void error(String tag, String s) {
        StackTraceElement e = Thread.currentThread().getStackTrace()[2];
        Logger.write("ERROR", tag, e.getFileName(), e.getLineNumber(), s, true, true);
        new RuntimeException().printStackTrace();
    }

    public static void info(String tag, String s) {
        StackTraceElement e = Thread.currentThread().getStackTrace()[2];
        Logger.write("INFO", tag, e.getFileName(), e.getLineNumber(), s);
    }

    public static void verboseInfo(String tag, String s) {
        if (Game.isVerbose()) {
            StackTraceElement e = Thread.currentThread().getStackTrace()[2];
            Logger.write("VER", tag, e.getFileName(), e.getLineNumber(), s, false, false);
        }
    }

    public static void debug(String tag, String s) {
        StackTraceElement e = Thread.currentThread().getStackTrace()[2];
        Logger.write("DEBUG", tag, e.getFileName(), e.getLineNumber(), s, false, Game.isDebug());
    }

    static {
        try {
            writer = new BufferedWriter(new FileWriter("engine-pi.log", false));
        }
        catch (IOException e) {
            File log = new File("engine-pi.log");
            if (log.isDirectory()) {
                System.err.println("Logger konnte nicht initialisiert werden, da 'engine-pi.log' ein Verzeichnis ist!");
                System.exit(1);
            }
            if (!log.canWrite()) {
                System.err.println("Logger konnte nicht initialisiert werden, da 'engine-pi.log' nicht beschreibbar ist!");
                System.exit(1);
            }
            System.err.println("Logger konnte aus unbekannten Gr\u00fcnden nicht initialisiert werden!");
            System.exit(1);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

