/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.sound;

import de.pirckheimer_gymnasium.engine_pi.sound.Sound;
import de.pirckheimer_gymnasium.engine_pi.sound.Track;
import java.util.Iterator;
import java.util.Objects;
import javax.sound.sampled.AudioFormat;

public class LoopedTrack
implements Track,
Iterator<Sound> {
    private final Sound track;

    public LoopedTrack(Sound sound) {
        this.track = Objects.requireNonNull(sound);
    }

    @Override
    public Iterator<Sound> iterator() {
        return this;
    }

    @Override
    public AudioFormat getFormat() {
        return this.track.getFormat();
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public Sound next() {
        return this.track;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object anObject) {
        if (this == anObject) return true;
        if (!(anObject instanceof LoopedTrack)) return false;
        LoopedTrack lt = (LoopedTrack)anObject;
        if (!lt.track.equals(this.track)) return false;
        return true;
    }

    public int hashCode() {
        return this.track.hashCode();
    }

    public String toString() {
        return "looped track: " + this.track;
    }
}

