/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi;

import de.pirckheimer_gymnasium.engine_pi.resources.ColorContainer;
import de.pirckheimer_gymnasium.engine_pi.resources.ColorScheme;
import de.pirckheimer_gymnasium.engine_pi.resources.ColorSchemeSelection;
import de.pirckheimer_gymnasium.engine_pi.resources.FontContainer;
import de.pirckheimer_gymnasium.engine_pi.resources.ImageContainer;
import de.pirckheimer_gymnasium.engine_pi.resources.SoundContainer;
import java.awt.Color;

public final class Resources {
    public static final ColorContainer COLORS = new ColorContainer();
    public static final FontContainer FONTS = new FontContainer();
    public static final ImageContainer IMAGES = new ImageContainer();
    public static final SoundContainer SOUNDS = new SoundContainer();
    public static ColorScheme colorScheme;

    private Resources() {
        throw new UnsupportedOperationException();
    }

    public static void setColorScheme(ColorScheme scheme) {
        colorScheme = scheme;
        COLORS.addScheme(colorScheme);
    }

    public static void setColorSchemeToPredefined(ColorSchemeSelection selection) {
        Resources.setColorScheme(selection.getScheme());
    }

    public static Color getColor(String name) {
        return COLORS.get(name);
    }

    public static ImageContainer getImages() {
        return IMAGES;
    }

    public static SoundContainer getSounds() {
        return SOUNDS;
    }

    public static void clearAll() {
        COLORS.clear();
        FONTS.clear();
        IMAGES.clear();
        SOUNDS.clear();
    }

    static {
        Resources.setColorSchemeToPredefined(ColorSchemeSelection.GNOME);
        COLORS.addScheme(colorScheme);
    }
}

