/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Hexagon;
import de.pirckheimer_gymnasium.engine_pi.actor.Image;
import de.pirckheimer_gymnasium.engine_pi.actor.Pentagon;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.actor.RegularPolygon;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.actor.Triangle;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import java.awt.Color;

public interface ActorAdder {
    public Scene getScene();

    default public Circle addCircle(double diameter, double x, double y) {
        Circle actor = new Circle(diameter);
        actor.setPosition(x, y);
        this.getScene().add(actor);
        return actor;
    }

    default public Circle addCircle(double x, double y) {
        return this.addCircle(1.0, x, y);
    }

    default public Circle addCircle(double x, double y, Color color) {
        Circle actor = this.addCircle(1.0, x, y);
        actor.setColor(color);
        return actor;
    }

    default public Circle addCircle() {
        return this.addCircle(1.0, 0.0, 0.0);
    }

    default public Circle addCircle(double diameter) {
        return this.addCircle(diameter, 0.0, 0.0);
    }

    default public Hexagon addHexagon(double radius) {
        Hexagon actor = new Hexagon(radius);
        this.getScene().add(actor);
        return actor;
    }

    default public Hexagon addHexagon(double radius, double x, double y) {
        Hexagon actor = this.addHexagon(radius);
        actor.setPosition(x, y);
        return actor;
    }

    default public Hexagon addHexagon(double x, double y) {
        return this.addHexagon(0.5, x, y);
    }

    default public Hexagon addHexagon(double x, double y, String color) {
        Hexagon actor = this.addHexagon(x, y);
        actor.setColor(color);
        return actor;
    }

    default public Hexagon addHexagon(double radius, double x, double y, String color) {
        Hexagon actor = this.addHexagon(radius, x, y);
        actor.setColor(color);
        return actor;
    }

    default public Image addImage(String filePath, double pixelPerMeter) {
        Image actor = new Image(filePath, pixelPerMeter);
        this.getScene().add(actor);
        return actor;
    }

    default public Image addImage(String filePath, double width, double height) {
        Image actor = new Image(filePath, width, height);
        this.getScene().add(actor);
        return actor;
    }

    default public Pentagon addPentagon(double radius) {
        Pentagon actor = new Pentagon(radius);
        this.getScene().add(actor);
        return actor;
    }

    default public Pentagon addPentagon(double radius, double x, double y) {
        Pentagon actor = this.addPentagon(radius);
        actor.setPosition(x, y);
        return actor;
    }

    default public Pentagon addPentagon(double x, double y) {
        return this.addPentagon(0.5, x, y);
    }

    default public Rectangle addRectangle(double width, double height, double x, double y) {
        Rectangle actor = new Rectangle(width, height);
        actor.setPosition(x, y);
        this.getScene().add(actor);
        return actor;
    }

    default public Rectangle addRectangle(double width, double height) {
        return this.addRectangle(width, height, 0.0, 0.0);
    }

    default public Rectangle addRectangle(int x, int y) {
        return this.addRectangle(1.0, 1.0, x, y);
    }

    default public Triangle addTriangle(int x, int y) {
        Triangle actor = this.addTriangle(1.0, 1.0);
        actor.setPosition(x, y);
        return actor;
    }

    default public Triangle addTriangle(Vector point1, Vector point2, Vector point3) {
        Triangle actor = new Triangle(point1, point2, point3);
        this.getScene().add(actor);
        return actor;
    }

    @API
    default public Triangle addTriangle(double x1, double y1, double x2, double y2, double x3, double y3) {
        Triangle actor = new Triangle(x1, y1, x2, y2, x3, y3);
        this.getScene().add(actor);
        return actor;
    }

    default public Triangle addTriangle(double width, double height) {
        Triangle actor = new Triangle(width, height);
        this.getScene().add(actor);
        return actor;
    }

    default public Triangle addTriangle(double sideLength) {
        Triangle actor = new Triangle(sideLength);
        this.getScene().add(actor);
        return actor;
    }

    default public RegularPolygon addRegularPolygon(int numSides, double radius) {
        RegularPolygon actor = new RegularPolygon(numSides, radius);
        this.getScene().add(actor);
        return actor;
    }

    default public RegularPolygon addRegularPolygon(int numSides) {
        return this.addRegularPolygon(numSides, 1.0);
    }

    default public RegularPolygon addRegularPolygon(int numSides, double radius, double x, double y) {
        RegularPolygon actor = this.addRegularPolygon(numSides, radius);
        actor.setPosition(x, y);
        return actor;
    }

    default public RegularPolygon addRegularPolygon(int numSides, double x, double y) {
        return this.addRegularPolygon(numSides, 1.0, x, y);
    }

    default public Text addText(String content, double height) {
        Text actor = new Text(content, height);
        this.getScene().add(actor);
        return actor;
    }

    default public Text addText(String content) {
        return this.addText(content, 1.0);
    }

    default public Text addText(String content, double height, double x, double y) {
        Text actor = this.addText(content, height);
        actor.setPosition(x, y);
        return actor;
    }

    default public Text addText(String content, double x, double y) {
        return this.addText(content, 1.0, x, y);
    }
}

